/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.terminals;

import java.util.regex.Pattern;

public class ID {
    private static final Pattern STRING_PATTERN = Pattern.compile("[a-zA-Z\\u0080-\\u00FF_][a-zA-Z\\u0080-\\u00FF_0-9]*");
    private static final Pattern NUMERAL_PATTERN = Pattern.compile("-?(\\.\\d+)|(\\d+(\\.\\d*)?)");
    private String string;
    private Type type;

    private ID(String string, Type type) {
        this.string = string;
        this.type = type;
    }

    public static ID fromString(String string, Type type) {
        if (string == null) {
            return null;
        }
        return new ID(string, type);
    }

    public static ID fromString(String string) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return ID.fromString(string, Type.QUOTED_STRING);
        }
        if (string.matches("^<.*>$")) {
            return ID.fromString(string, Type.HTML_STRING);
        }
        if (string.matches("^\".*\"$")) {
            return ID.fromString(string, Type.QUOTED_STRING);
        }
        if (NUMERAL_PATTERN.matcher(string).matches()) {
            return ID.fromValue(string, Type.NUMERAL);
        }
        return ID.fromString(string, Type.STRING);
    }

    public static ID fromValue(String value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return ID.fromValue(value, Type.QUOTED_STRING);
        }
        if (NUMERAL_PATTERN.matcher(value).matches()) {
            return ID.fromValue(value, Type.NUMERAL);
        }
        if (!(!STRING_PATTERN.matcher(value).matches() || value.equalsIgnoreCase("node") || value.equalsIgnoreCase("edge") || value.equalsIgnoreCase("graph") || value.equalsIgnoreCase("digraph") || value.equalsIgnoreCase("subgraph") || value.equalsIgnoreCase("strict"))) {
            return ID.fromValue(value, Type.STRING);
        }
        return ID.fromValue(value, Type.QUOTED_STRING);
    }

    public static ID fromValue(String value, Type type) {
        if (value == null) {
            return null;
        }
        return new ID(ID.encode(value, type), type);
    }

    private static String encode(String value, Type type) {
        switch (type) {
            case NUMERAL: 
            case STRING: {
                return value;
            }
            case QUOTED_STRING: {
                return "\"" + value.replaceAll("\"", "\\\\\"") + "\"";
            }
            case HTML_STRING: {
                return "<" + value + ">";
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)type));
    }

    private static String decode(String string, Type type) {
        switch (type) {
            case NUMERAL: 
            case STRING: {
                return string;
            }
            case QUOTED_STRING: {
                return string.replaceAll("^\"|\"$", "").replaceAll("\\\\(?:\\r\\n|\\r|\\n)", "").replaceAll("\\\\\"", "\"");
            }
            case HTML_STRING: {
                return string.replaceAll("^<|>$", "");
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)type));
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.string;
    }

    public String toValue() {
        return ID.decode(this.string, this.type);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.string == null ? 0 : this.string.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ID other = (ID)obj;
        if (this.string == null ? other.string != null : !this.string.equals(other.string)) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum Type {
        NUMERAL,
        STRING,
        QUOTED_STRING,
        HTML_STRING;

    }
}

