/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.dialogs;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class OptionalMessageDialog
extends MessageDialog {
    private static final String CHECKBOX_TEXT = JptCommonUiMessages.OPTIONAL_MESSAGE_DIALOG__DO_NOT_SHOW_WARNING;
    private static final String STORE_ID = "OptionalMessageDialog.hide.";
    public static final int NOT_SHOWN = 1025;
    final String id;
    private final String checkBoxText;

    public OptionalMessageDialog(String id, Shell parentShell, String dialogTitle, String dialogMessage, int dialogType, String[] buttonLabels, int defaultButtonIndex) {
        this(id, parentShell, dialogTitle, dialogMessage, dialogType, buttonLabels, defaultButtonIndex, CHECKBOX_TEXT);
    }

    public OptionalMessageDialog(String id, Shell parentShell, String dialogTitle, String dialogMessage, int dialogType, String[] buttonLabels, int defaultButtonIndex, String checkBoxText) {
        super(parentShell, dialogTitle, null, dialogMessage, dialogType, buttonLabels, defaultButtonIndex);
        this.id = id;
        this.checkBoxText = checkBoxText;
    }

    protected Control createCustomArea(Composite parent) {
        Button checkbox = new Button(parent, 32);
        checkbox.setText(this.checkBoxText);
        checkbox.setSelection(false);
        checkbox.setLayoutData((Object)new GridData(1808));
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionalMessageDialog.setDialogEnabled(OptionalMessageDialog.this.id, !((Button)e.widget).getSelection());
            }
        });
        return checkbox;
    }

    private static IDialogSettings getDialogSettings() {
        IDialogSettings settings = OptionalMessageDialog.getJavaUIPlugin().getDialogSettings();
        if ((settings = settings.getSection(STORE_ID)) == null) {
            settings = OptionalMessageDialog.getJavaUIPlugin().getDialogSettings().addNewSection(STORE_ID);
        }
        return settings;
    }

    public static boolean isDialogEnabled(String key) {
        IDialogSettings settings = OptionalMessageDialog.getDialogSettings();
        return !settings.getBoolean(key);
    }

    public static void setDialogEnabled(String key, boolean isEnabled) {
        IDialogSettings settings = OptionalMessageDialog.getDialogSettings();
        settings.put(key, !isEnabled);
    }

    public static void clearAllRememberedStates() {
        IDialogSettings settings = OptionalMessageDialog.getJavaUIPlugin().getDialogSettings();
        settings.addNewSection(STORE_ID);
    }

    private static AbstractUIPlugin getJavaUIPlugin() {
        return JavaPlugin.getDefault();
    }
}

