/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands.processes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jwt.meta.commands.processes.RemoveActivityNodeCommand;
import org.eclipse.jwt.meta.model.processes.Action;
import org.eclipse.jwt.meta.model.processes.ActivityNode;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.util.EMFHelper;
import org.eclipse.jwt.we.misc.views.LayoutDataManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WERemoveActivityNodeCommand
extends RemoveActivityNodeCommand {
    private WEEditor weeditor;
    private EditingDomain editingDomain;
    private Command removeViewDataCommand;

    public WERemoveActivityNodeCommand(WEEditor weeditor, EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        super(domain, owner, feature, collection);
        this.editingDomain = domain;
        this.weeditor = weeditor;
    }

    public void doExecute() {
        ArrayList<ActivityNode> newCollection = new ArrayList<ActivityNode>();
        for (ActivityNode actNode : this.collection) {
            if (actNode.eContainer() == null) continue;
            newCollection.add(actNode);
        }
        this.collection = newCollection;
        this.removeEdgesCommands = new CompoundCommand();
        for (ActivityNode node : this.collection) {
            if (!node.getIn().isEmpty()) {
                this.removeEdgesCommands.append(DeleteCommand.create((EditingDomain)this.editingDomain, (Collection)node.getIn()));
            }
            if (!node.getOut().isEmpty()) {
                this.removeEdgesCommands.append(DeleteCommand.create((EditingDomain)this.editingDomain, (Collection)node.getOut()));
            }
            if (!(node instanceof Action) || EMFHelper.getReferenceEdgesForAction(this.weeditor, (Action)node).isEmpty()) continue;
            this.removeEdgesCommands.append(DeleteCommand.create((EditingDomain)this.editingDomain, EMFHelper.getReferenceEdgesForAction(this.weeditor, (Action)node)));
        }
        this.createDeleteViewDataCommand();
        if (this.removeEdgesCommands.canExecute()) {
            this.removeEdgesCommands.execute();
        }
        this.doExecuteOriginal();
        if (this.removeViewDataCommand.canExecute()) {
            this.removeViewDataCommand.execute();
        }
    }

    public void doRedo() {
        super.doRedo();
        if (this.removeViewDataCommand.canExecute()) {
            this.removeViewDataCommand.redo();
        }
    }

    public void doUndo() {
        if (this.removeViewDataCommand.canUndo()) {
            this.removeViewDataCommand.undo();
        }
        super.doUndo();
    }

    private void createDeleteViewDataCommand() {
        Collection laydataCollection = LayoutDataManager.getAllContainedLayoutDatas(this.weeditor, this.collection);
        Collection refEdgesCollection = EMFHelper.getAllContainedReferenceEdges(this.weeditor, this.collection);
        Collection refsCollection = EMFHelper.getAllContainedReferences(this.weeditor, this.collection);
        HashSet removeViewDataSet = new HashSet();
        if (laydataCollection != null) {
            removeViewDataSet.addAll(laydataCollection);
        }
        if (refEdgesCollection != null) {
            removeViewDataSet.addAll(refEdgesCollection);
        }
        if (refsCollection != null) {
            removeViewDataSet.addAll(refsCollection);
        }
        this.removeViewDataCommand = DeleteCommand.create((EditingDomain)this.editingDomain, removeViewDataSet);
    }

    public void doDispose() {
        super.doDispose();
        if (this.removeViewDataCommand != null) {
            this.removeViewDataCommand.dispose();
        }
    }
}

