/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.figures.internal;

import java.util.MissingResourceException;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.figures.IImageFactory;
import org.eclipse.jwt.we.figures.internal.ScalingImageDescriptor;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageFactory
implements IImageFactory {
    private static final Logger logger = Logger.getLogger(ImageFactory.class);
    private final String iconBasePath;
    private final EclipseUIPlugin plugin;
    public static final Dimension MODEL_TYPE_IMAGE_SIZE = new Dimension(16, 16);
    private final ImageRegistry imageRegistry;

    public ImageFactory(ImageRegistry imageRegistry, EclipseUIPlugin plugin, String iconBasePath) {
        assert (imageRegistry != null);
        this.imageRegistry = imageRegistry;
        this.iconBasePath = iconBasePath;
        this.plugin = plugin;
    }

    public Image getImage(ImageDescriptor imageDescriptor) {
        return this.getImage(imageDescriptor, null);
    }

    public Image getImage(ImageDescriptor imageDescriptor, Dimension size) {
        if (imageDescriptor == null) {
            return null;
        }
        if (!(imageDescriptor instanceof ScalingImageDescriptor)) {
            imageDescriptor = new ScalingImageDescriptor(imageDescriptor, size);
        } else if (size != null) {
            ((ScalingImageDescriptor)imageDescriptor).setSize(size);
        }
        String name = imageDescriptor.toString();
        Image image = this.imageRegistry.get(name);
        if (image != null) {
            logger.debug("Image found in registry as: " + name);
        } else {
            try {
                this.imageRegistry.put(name, imageDescriptor);
                logger.debug("Registry miss. New entry: " + name);
                image = this.imageRegistry.get(name);
            }
            catch (Exception exception) {
                logger.warning("Error creating image " + name);
            }
        }
        return image;
    }

    public ImageDescriptor createImageDescriptor(String path) {
        String temppath = String.valueOf(this.iconBasePath) + path;
        ImageDescriptor result = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.plugin.getBundle().getSymbolicName(), (String)temppath);
        return result;
    }

    public ImageDescriptor createModelTypeImageDescriptor(Object model) {
        String path;
        try {
            path = PluginProperties.model_smallIcon(model);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        ImageDescriptor imageDescriptor = this.createImageDescriptor(path);
        if (imageDescriptor == null) {
            return null;
        }
        ImageData data = imageDescriptor.getImageData();
        ScalingImageDescriptor result = data == null ? null : new ScalingImageDescriptor(imageDescriptor, MODEL_TYPE_IMAGE_SIZE);
        return result;
    }

    public String getIconBasePath() {
        return this.iconBasePath;
    }
}

