/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.actions.external.WEExternalAction;
import org.eclipse.jwt.we.editors.actions.external.WEExternalActionsManager;
import org.eclipse.jwt.we.editors.actions.internalActions.CreateChildAction;
import org.eclipse.jwt.we.editors.actions.internalActions.CreateSiblingAction;
import org.eclipse.jwt.we.editors.actions.managed.sheet.ExternalSheetAction;
import org.eclipse.jwt.we.editors.actions.managed.zoom.ZoomControl;
import org.eclipse.jwt.we.editors.pages.activityEditor.internal.IActivityEditor;
import org.eclipse.jwt.we.editors.pages.externalSheet.internal.WEExternalSheetManager;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.part.EditorActionBarContributor;

public class ActionBarContributor
extends EditorActionBarContributor
implements ISelectionChangedListener,
IMenuListener {
    private static final Logger logger = Logger.getLogger(ActionBarContributor.class);
    private IEditorPart activeEditorPart;
    private ISelectionProvider selectionProvider;
    private Collection createChildActions;
    private Collection createSiblingActions;
    private Object selectedObject;
    private ICoolBarManager coolBarManager;

    public ActionBarContributor() {
        logger.instanceCreation();
    }

    public void init(IActionBars bars) {
        super.init(bars);
    }

    protected ActionRegistry getActionRegistry() {
        if (this.activeEditorPart == null) {
            return null;
        }
        return (ActionRegistry)this.activeEditorPart.getAdapter(ActionRegistry.class);
    }

    public void setActiveEditor(IEditorPart newEditor) {
        logger.enter(newEditor.getClass().getName());
        Views.getInstance().refreshViewsState((WEEditor)this.activeEditorPart);
        if (newEditor == this.activeEditorPart) {
            return;
        }
        this.activeEditorPart = newEditor;
        ((WEEditor)this.activeEditorPart).refreshZoom();
        if (((WEEditor)this.activeEditorPart).getActiveEditor() instanceof IActivityEditor) {
            ((WEEditor)this.activeEditorPart).getCurrentActivitySheet().setGridProperties();
        }
        IActionBars bars = this.getActionBars();
        ArrayList globalActionIDs = ((WEEditor)this.activeEditorPart).getGlobalActionKeys();
        int i = 0;
        while (i < globalActionIDs.size()) {
            String id = (String)globalActionIDs.get(i);
            bars.setGlobalActionHandler(id, this.getActionRegistry().getAction((Object)id));
            ++i;
        }
        bars.updateActionBars();
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this.activeEditorPart == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = this.activeEditorPart.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectedObject = null;
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            this.selectedObject = ((IStructuredSelection)selection).getFirstElement();
            if (this.selectedObject instanceof Reference) {
                this.selectedObject = ((Reference)this.selectedObject).getReference();
            }
            logger.valueChanged("selectedObject", this.selectedObject);
            EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)this.selectedObject);
            if (domain != null) {
                newChildDescriptors = domain.getNewChildDescriptors(this.selectedObject, null);
                newSiblingDescriptors = domain.getNewChildDescriptors(null, this.selectedObject);
                selection = new StructuredSelection(this.selectedObject);
            }
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        logger.enter();
        GEFActionConstants.addStandardActionGroups((IMenuManager)menuManager);
        this.addGlobalActionsToPopup(menuManager);
        boolean externalGroup1 = this.addExternalActionsToPopup(menuManager);
        boolean externalGroup2 = this.addExternalSheetsToPopup(menuManager);
        if (externalGroup1 || externalGroup2) {
            menuManager.appendToGroup("group.add", (IContributionItem)new Separator());
        }
        this.addCreationSubMenusToPopup(menuManager);
    }

    protected void addGlobalActionsToPopup(IMenuManager menuManager) {
        if (this.getActionRegistry() == null) {
            return;
        }
        menuManager.appendToGroup("org.eclipse.gef.group.edit", this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        menuManager.insertBefore("org.eclipse.gef.group.view", (IContributionItem)new GroupMarker("org.eclipse.jwt.we.grid"));
    }

    protected boolean addExternalActionsToPopup(IMenuManager menuManager) {
        if (WEExternalActionsManager.getInstance().getExternalActions().size() == 0) {
            return false;
        }
        MenuManager subMenuManager = new MenuManager(PluginProperties.menu_External_label, "external");
        for (WEExternalAction externalAction : WEExternalActionsManager.getInstance().getExternalActions()) {
            subMenuManager.add((IAction)externalAction);
        }
        menuManager.appendToGroup("group.add", (IContributionItem)subMenuManager);
        return true;
    }

    protected boolean addExternalSheetsToPopup(IMenuManager menuManager) {
        if (WEExternalSheetManager.getInstance().getExternalSheets().size() == 0) {
            return false;
        }
        MenuManager subMenuManager = new MenuManager(PluginProperties.menu_ExternalSheet_label, "externalsheet");
        for (String externalSheetTitle : WEExternalSheetManager.getInstance().getExternalSheets().keySet()) {
            ExternalSheetAction externalSheetAction = new ExternalSheetAction(externalSheetTitle);
            subMenuManager.add((IAction)externalSheetAction);
        }
        menuManager.appendToGroup("group.add", (IContributionItem)subMenuManager);
        return true;
    }

    protected void addCreationSubMenusToPopup(IMenuManager menuManager) {
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(PluginProperties.menu_CreateChild_item);
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.appendToGroup("group.add", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(PluginProperties.menu_CreateSibling_item);
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.appendToGroup("group.add", (IContributionItem)submenuManager);
    }

    protected Collection generateCreateChildActions(Collection descriptors, ISelection selection) {
        ArrayList<CreateChildAction> actions = new ArrayList<CreateChildAction>();
        if (descriptors != null) {
            actions.ensureCapacity(descriptors.size());
            Iterator i = descriptors.iterator();
            while (i.hasNext()) {
                actions.add(new CreateChildAction(this.activeEditorPart, selection, i.next()));
            }
        }
        return actions;
    }

    protected Collection generateCreateSiblingActions(Collection descriptors, ISelection selection) {
        ArrayList<CreateSiblingAction> actions = new ArrayList<CreateSiblingAction>();
        if (descriptors != null) {
            actions.ensureCapacity(descriptors.size());
            Iterator i = descriptors.iterator();
            while (i.hasNext()) {
                actions.add(new CreateSiblingAction(this.activeEditorPart, selection, i.next()));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection actions, String contributionID) {
        if (actions != null) {
            for (IAction action : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, action);
                    continue;
                }
                manager.add(action);
            }
        }
    }

    public void contributeToCoolBar(ICoolBarManager coolBarManager) {
        this.coolBarManager = coolBarManager;
        this.addZoomGroupToCoolbar(coolBarManager);
        this.addExternalGroupCoolbar(coolBarManager);
    }

    private void addZoomGroupToCoolbar(ICoolBarManager coolBarManager) {
        ToolBarContributionItem zoomGroup = (ToolBarContributionItem)coolBarManager.find("org.eclipse.jwt.we.zoomBar");
        if (zoomGroup == null) {
            return;
        }
        String[] zoomStrings = new String[]{ZoomManager.FIT_ALL, ZoomManager.FIT_HEIGHT, ZoomManager.FIT_WIDTH};
        ZoomComboContributionItem zoomItem = new ZoomComboContributionItem((IPartService)this.getPage(), zoomStrings);
        zoomGroup.getToolBarManager().insertAfter("org.eclipse.jwt.we.zoomBar.zoomIn", (IContributionItem)zoomItem);
        ZoomControl.getInstance().setZoomItem(zoomItem);
    }

    private void addExternalGroupCoolbar(ICoolBarManager coolBarManager) {
        ToolBarContributionItem externalGroup = (ToolBarContributionItem)coolBarManager.find("org.eclipse.jwt.we.externalBar");
        if (WEExternalActionsManager.getInstance().getExternalActions().size() == 0) {
            externalGroup.getToolBarManager().removeAll();
            return;
        }
    }

    public void dispose() {
        super.dispose();
        ToolBarContributionItem zoomGroup = (ToolBarContributionItem)this.coolBarManager.find("org.eclipse.jwt.we.zoomBar");
        zoomGroup.getToolBarManager().remove("org.eclipse.gef.zoom_widget");
        zoomGroup.getToolBarManager().update(true);
        this.coolBarManager.update(true);
        this.coolBarManager = null;
        ZoomControl.getInstance().disableZoom();
    }
}

