/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.nature;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.handlers.HandlerUtil;

public class ModelingToggleNatureAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Set<IProject> selectedProjects = this.getSelectedProjects(event);
        for (IProject project : selectedProjects) {
            this.toggleNature(project);
        }
        return null;
    }

    private Set<IProject> getSelectedProjects(ExecutionEvent event) {
        HashSet<IProject> selectedProjects = new HashSet<IProject>();
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            for (Object object : ((IStructuredSelection)currentSelection).toList()) {
                if (object instanceof IProject) {
                    selectedProjects.add((IProject)object);
                    continue;
                }
                if (object instanceof IProjectNature) {
                    IProjectNature nature = (IProjectNature)object;
                    selectedProjects.add(nature.getProject());
                    continue;
                }
                if (!(Platform.getAdapterManager().getAdapter(object, IProject.class) instanceof IProject)) continue;
                selectedProjects.add((IProject)Platform.getAdapterManager().getAdapter(object, IProject.class));
            }
        }
        return selectedProjects;
    }

    private void toggleNature(final IProject project) {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)new WorkspaceModifyOperation((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    block4: {
                        try {
                            if (ModelingProject.hasModelingProjectNature((IProject)project)) {
                                ModelingProjectManager.INSTANCE.removeModelingNature(project, monitor);
                            } else {
                                ModelingProjectManager.INSTANCE.convertToModelingProject(project, monitor);
                            }
                        }
                        catch (CoreException e) {
                            UICallBack uiCallback = SiriusEditPlugin.getPlugin().getUiCallback();
                            if (uiCallback == null) break block4;
                            uiCallback.openError(Messages.ModelingToggleNatureAction_errorDialogTitle, MessageFormat.format(Messages.ModelingToggleNatureAction_errorDialogMessage, e.getMessage()));
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

