/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.validation.core;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.viatra.addon.validation.core.Constraint;
import org.eclipse.viatra.addon.validation.core.MatchAppearanceJob;
import org.eclipse.viatra.addon.validation.core.MatchDisappearanceJob;
import org.eclipse.viatra.addon.validation.core.MatchUpdateJob;
import org.eclipse.viatra.addon.validation.core.ValidationEngineBuilder;
import org.eclipse.viatra.addon.validation.core.api.IConstraint;
import org.eclipse.viatra.addon.validation.core.api.IConstraintSpecification;
import org.eclipse.viatra.addon.validation.core.api.IValidationEngine;
import org.eclipse.viatra.addon.validation.core.listeners.ValidationEngineListener;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.ExecutionSchema;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.Scheduler;
import org.eclipse.viatra.transformation.evm.specific.ExecutionSchemas;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.Schedulers;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.viatra.transformation.evm.specific.scheduler.UpdateCompleteBasedScheduler;

public class ValidationEngine
implements IValidationEngine {
    private Logger logger;
    private ViatraQueryEngine queryEngine;
    private ExecutionSchema executionSchema;
    private Map<IConstraintSpecification, Constraint> constraintMap;
    private Set<ValidationEngineListener> listeners;

    protected ViatraQueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    protected ExecutionSchema getExecutionSchema() {
        return this.executionSchema;
    }

    public static ValidationEngineBuilder builder() {
        return ValidationEngineBuilder.create();
    }

    protected ValidationEngine(ViatraQueryEngine engine, Logger logger) {
        Preconditions.checkArgument((engine != null ? 1 : 0) != 0, (String)"Engine cannot be null");
        Preconditions.checkArgument((logger != null ? 1 : 0) != 0, (String)"Logger cannot be null");
        this.queryEngine = engine;
        this.logger = logger;
        this.constraintMap = new HashMap<IConstraintSpecification, Constraint>();
        this.listeners = new HashSet<ValidationEngineListener>();
        UpdateCompleteBasedScheduler.UpdateCompleteBasedSchedulerFactory schedulerFactory = Schedulers.getQueryEngineSchedulerFactory((ViatraQueryEngine)this.queryEngine);
        this.executionSchema = ExecutionSchemas.createViatraQueryExecutionSchema((ViatraQueryEngine)this.queryEngine, (Scheduler.ISchedulerFactory)schedulerFactory);
    }

    @Override
    public void initialize() {
        this.executionSchema.startUnscheduledExecution();
    }

    @Override
    public void dispose() {
        this.executionSchema.dispose();
        this.constraintMap.clear();
        this.listeners.clear();
    }

    public Set<IConstraint> getConstraints() {
        return ImmutableSet.copyOf(this.constraintMap.values());
    }

    @Override
    public IConstraint addConstraintSpecification(IConstraintSpecification constraintSpecification) {
        Constraint constraint = new Constraint(constraintSpecification, this, this.logger);
        if (this.constraintMap.put(constraintSpecification, constraint) == null) {
            this.notifyListenersConstraintRegistered(constraint);
        }
        return constraint;
    }

    @Override
    public IConstraint removeConstraintSpecification(IConstraintSpecification constraintSpecification) {
        Constraint constraint = this.constraintMap.get(constraintSpecification);
        this.removeRuleSpecificationFromExecutionSchema(constraint);
        if (this.constraintMap.remove(constraintSpecification) != null) {
            this.notifyListenersConstraintDeregistered(constraint);
        }
        return constraint;
    }

    protected boolean addRuleSpecificationToExecutionSchema(Constraint constraint) {
        ImmutableSet jobs = ImmutableSet.of((Object)Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, (Consumer)new MatchAppearanceJob(constraint, this.logger))), (Object)Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, (Consumer)new MatchDisappearanceJob(constraint, this.logger))), (Object)Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, (Consumer)new MatchUpdateJob(constraint, this.logger))));
        IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> querySpecification = constraint.getSpecification().getQuerySpecification();
        RuleSpecification rule = Rules.newMatcherRuleSpecification(querySpecification, (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), (Set)jobs);
        constraint.setRuleSpecification((RuleSpecification<IPatternMatch>)rule);
        boolean added = this.executionSchema.addRule(rule);
        this.executionSchema.startUnscheduledExecution();
        return added;
    }

    protected boolean removeRuleSpecificationFromExecutionSchema(Constraint constraint) {
        RuleSpecification<IPatternMatch> ruleSpecification = constraint.getRuleSpecification();
        if (ruleSpecification != null) {
            constraint.setRuleSpecification(null);
            return this.executionSchema.removeRule(ruleSpecification);
        }
        return false;
    }

    public Set<ValidationEngineListener> getListeners() {
        return ImmutableSet.copyOf(this.listeners);
    }

    @Override
    public boolean addListener(ValidationEngineListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(ValidationEngineListener listener) {
        return this.listeners.remove(listener);
    }

    protected void notifyListenersConstraintRegistered(Constraint constraint) {
        for (ValidationEngineListener listener : this.listeners) {
            listener.constraintRegistered(constraint);
        }
    }

    protected void notifyListenersConstraintDeregistered(Constraint constraint) {
        for (ValidationEngineListener listener : this.listeners) {
            listener.constraintDeregistered(constraint);
        }
    }
}

