/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.scopes.tables;

import java.util.Collections;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.AbstractIndexTable;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableContext;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableWriterBinary;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiLookup;

public class SimpleBinaryTable<Source, Target>
extends AbstractIndexTable
implements ITableWriterBinary.Table<Source, Target> {
    private IMultiLookup<Target, Source> valueToHolderMap;
    private IMultiLookup<Source, Target> holderToValueMap;
    private int totalRowCount = 0;
    private boolean unique;

    public SimpleBinaryTable(IInputKey inputKey, ITableContext tableContext, boolean unique) {
        super(inputKey, tableContext);
        this.unique = unique;
        this.valueToHolderMap = CollectionsFactory.createMultiLookup(Object.class, unique ? CollectionsFactory.MemoryType.SETS : CollectionsFactory.MemoryType.MULTISETS, Object.class);
        if (2 != inputKey.getArity()) {
            throw new IllegalArgumentException(inputKey.toString());
        }
    }

    @Override
    public void write(Direction direction, Source holder, Target value) {
        if (direction == Direction.INSERT) {
            try {
                boolean changed = this.addToValueToHolderMap(value, holder);
                if (this.holderToValueMap != null) {
                    this.addToHolderToValueMap(value, holder);
                }
                if (changed) {
                    ++this.totalRowCount;
                }
            }
            catch (IllegalStateException ex) {
                String msg = String.format("Error: trying to add duplicate value %s to the unique feature %s of host object %s. This indicates some errors in underlying model representation.", value, this.getInputKey().getPrettyPrintableName(), holder);
                this.logError(msg);
            }
        } else {
            try {
                boolean changed = this.removeFromValueToHolderMap(value, holder);
                if (this.holderToValueMap != null) {
                    this.removeFromHolderToValueMap(value, holder);
                }
                if (changed) {
                    --this.totalRowCount;
                }
            }
            catch (IllegalStateException ex) {
                String msg = String.format("Error: trying to remove non-existing value %s from the feature %s of host object %s. This indicates some errors in underlying model representation.", value, this.getInputKey().getPrettyPrintableName(), holder);
                this.logError(msg);
            }
        }
    }

    private boolean addToHolderToValueMap(Target value, Source holder) {
        return IMultiLookup.ChangeGranularity.DUPLICATE != this.holderToValueMap.addPair(holder, value);
    }

    private boolean addToValueToHolderMap(Target value, Source holder) {
        return IMultiLookup.ChangeGranularity.DUPLICATE != this.valueToHolderMap.addPair(value, holder);
    }

    private boolean removeFromHolderToValueMap(Target value, Source holder) {
        return IMultiLookup.ChangeGranularity.DUPLICATE != this.holderToValueMap.removePair(holder, value);
    }

    private boolean removeFromValueToHolderMap(Target value, Source holder) {
        return IMultiLookup.ChangeGranularity.DUPLICATE != this.valueToHolderMap.removePair(value, holder);
    }

    @Override
    public int countTuples(TupleMask seedMask, ITuple seed) {
        switch (seedMask.getSize()) {
            case 0: {
                return this.totalRowCount;
            }
            case 1: {
                int seedIndex = seedMask.indices[0];
                if (seedIndex == 0) {
                    Object source = seed.get(0);
                    return this.getDistinctValuesOfHolder(source).size();
                }
                if (seedIndex == 1) {
                    Object target = seed.get(0);
                    return this.getDistinctHoldersOfValue(target).size();
                }
                throw new IllegalArgumentException(seedMask.toString());
            }
            case 2: {
                Object source = seedMask.getValue(seed, 0);
                Object target = seedMask.getValue(seed, 1);
                if (this.containsRow(source, target)) {
                    return 1;
                }
                return 0;
            }
        }
        throw new IllegalArgumentException(seedMask.toString());
    }

    @Override
    public Iterable<Tuple> enumerateTuples(TupleMask seedMask, ITuple seed) {
        switch (seedMask.getSize()) {
            case 0: {
                return () -> StreamSupport.stream(this.getAllDistinctValues().spliterator(), false).flatMap(value -> this.valueToHolderMap.lookup(value).distinctValues().stream().map(source -> Tuples.staticArityFlatTupleOf(source, value))).iterator();
            }
            case 1: {
                int seedIndex = seedMask.indices[0];
                if (seedIndex == 0) {
                    return () -> {
                        Object source = seed.get(0);
                        return this.getDistinctValuesOfHolder(source).stream().map(target -> Tuples.staticArityFlatTupleOf(source, target)).iterator();
                    };
                }
                if (seedIndex == 1) {
                    return () -> {
                        Object target = seed.get(0);
                        return this.getDistinctHoldersOfValue(target).stream().map(source -> Tuples.staticArityFlatTupleOf(source, target)).iterator();
                    };
                }
                throw new IllegalArgumentException(seedMask.toString());
            }
            case 2: {
                Object source = seedMask.getValue(seed, 0);
                Object target = seedMask.getValue(seed, 1);
                if (this.containsRow(source, target)) {
                    return Collections.singleton(Tuples.staticArityFlatTupleOf(source, target));
                }
                return Collections.emptySet();
            }
        }
        throw new IllegalArgumentException(seedMask.toString());
    }

    @Override
    public Iterable<? extends Object> enumerateValues(TupleMask seedMask, ITuple seed) {
        if (seedMask.getSize() != 1) {
            throw new IllegalArgumentException(seedMask.toString());
        }
        int seedIndex = seedMask.indices[0];
        if (seedIndex == 0) {
            return this.getDistinctValuesOfHolder(seed.get(0));
        }
        if (seedIndex == 1) {
            return this.getDistinctHoldersOfValue(seed.get(0));
        }
        throw new IllegalArgumentException(seedMask.toString());
    }

    @Override
    public boolean containsTuple(ITuple seed) {
        return this.containsRow(seed.get(0), seed.get(1));
    }

    public boolean containsRow(Source source, Target target) {
        if (this.valueToHolderMap != null) {
            IMemoryView<Source> holders = this.valueToHolderMap.lookup(target);
            return holders != null && holders.containsNonZero(source);
        }
        throw new UnsupportedOperationException("TODO implement");
    }

    public Iterable<Source> getAllDistinctHolders() {
        return this.getHolderToValueMap().distinctKeys();
    }

    public Iterable<Target> getAllDistinctValues() {
        return this.getValueToHolderMap().distinctKeys();
    }

    public Set<Source> getDistinctHoldersOfValue(Target value) {
        IMemoryView<Source> holdersMultiset = this.getValueToHolderMap().lookup(value);
        if (holdersMultiset == null) {
            return Collections.emptySet();
        }
        return holdersMultiset.distinctValues();
    }

    public Set<Target> getDistinctValuesOfHolder(Source holder) {
        IMemoryView<Target> valuesMultiset = this.getHolderToValueMap().lookup(holder);
        if (valuesMultiset == null) {
            return Collections.emptySet();
        }
        return valuesMultiset.distinctValues();
    }

    private IMultiLookup<Source, Target> getHolderToValueMap() {
        if (this.holderToValueMap == null) {
            this.holderToValueMap = CollectionsFactory.createMultiLookup(Object.class, CollectionsFactory.MemoryType.SETS, Object.class);
            for (Target value : this.valueToHolderMap.distinctKeys()) {
                for (Source holder : this.valueToHolderMap.lookup(value).distinctValues()) {
                    this.holderToValueMap.addPair(holder, value);
                }
            }
        }
        return this.holderToValueMap;
    }

    private IMultiLookup<Target, Source> getValueToHolderMap() {
        return this.valueToHolderMap;
    }
}

