/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.widgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.XmlObjectPresentation;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.xwt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.xwt.model.widgets.ItemInfo;

public final class ExpandItemInfo
extends ItemInfo {
    private final IObjectPresentation m_presentation = new XmlObjectPresentation((XmlObjectInfo)this){

        public List<ObjectInfo> getChildrenGraphical() throws Exception {
            if (!ExpandItemInfo.this.isExpanded()) {
                return ImmutableList.of();
            }
            return this.getChildrenTree();
        }
    };

    public ExpandItemInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(context, description, creationSupport);
    }

    public ControlInfo getControl() {
        return (ControlInfo)((Object)GenericsUtils.getFirstOrNull((List)this.getChildren(ControlInfo.class)));
    }

    private boolean isExpanded() throws Exception {
        return (Boolean)ReflectionUtils.invokeMethod((Object)this.getObject(), (String)"getExpanded()", (Object[])new Object[0]);
    }

    public IObjectPresentation getPresentation() {
        return this.m_presentation;
    }

    protected void refresh_fetch() throws Exception {
        Object object = this.getObject();
        int headerHeight = (Integer)ReflectionUtils.invokeMethod2((Object)object, (String)"getHeaderHeight");
        int x = ReflectionUtils.getFieldInt((Object)object, (String)"x");
        int y = ReflectionUtils.getFieldInt((Object)object, (String)"y");
        int width = ReflectionUtils.getFieldInt((Object)object, (String)"width");
        int height = ReflectionUtils.getFieldInt((Object)object, (String)"height");
        height = this.isExpanded() ? (height += headerHeight) : headerHeight;
        this.setModelBounds(new Rectangle(x, y, width, height));
        super.refresh_fetch();
    }

    void fixControlBounds() {
        for (ControlInfo control : this.getChildren(ControlInfo.class)) {
            Point offset = this.getModelBounds().getLocation().getNegated();
            control.getModelBounds().translate(offset);
            offset = this.getBounds().getLocation().getNegated();
            control.getBounds().translate(offset);
        }
    }

    public void command_TARGET_after(ControlInfo control) throws Exception {
        this.getPropertyByTitle("expanded").setValue((Object)true);
    }
}

