/***********************************************************************
 * Copyright (c) 2004, 2005 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Actuate Corporation - initial API and implementation
 ***********************************************************************/

package org.eclipse.birt.chart.examples.view.models;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.DataPointComponentImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;

public class Scatter
{

	public static final Chart createScatter( )
	{
		ChartWithAxes cwaScatter = ChartWithAxesImpl.create( );
		cwaScatter.setType( "Scatter Chart" ); //$NON-NLS-1$	
		cwaScatter.setSubType( "Standard Scatter Chart" ); //$NON-NLS-1$
		
		// Plot
		cwaScatter.getBlock( ).setBackground( ColorDefinitionImpl.WHITE( ) );
		cwaScatter.getPlot( ).getClientArea( ).getOutline( ).setVisible( false );
		cwaScatter.getPlot( )
				.getClientArea( )
				.setBackground( ColorDefinitionImpl.create( 255, 255, 225 ) );

		// Title
		cwaScatter.getTitle( )
				.getLabel( )
				.getCaption( )
				.setValue( "Scatter Chart" );//$NON-NLS-1$

		//Legend
		cwaScatter.getLegend( ).setVisible( false );

		// X-Axis
		Axis xAxisPrimary = ( (ChartWithAxesImpl) cwaScatter ).getPrimaryBaseAxes( )[0];
		xAxisPrimary.setType( AxisType.LINEAR_LITERAL );
		xAxisPrimary.getLabel( )
				.getCaption( )
				.setColor( ColorDefinitionImpl.GREEN( ).darker( ) );

		xAxisPrimary.getMajorGrid( ).setTickStyle( TickStyle.BELOW_LITERAL );
		xAxisPrimary.getMajorGrid( )
				.getLineAttributes( )
				.setStyle( LineStyle.DOTTED_LITERAL );
		xAxisPrimary.getMajorGrid( )
				.getLineAttributes( )
				.setColor( ColorDefinitionImpl.GREY( ) );
		xAxisPrimary.getMajorGrid( ).getLineAttributes( ).setVisible( true );
		xAxisPrimary.getOrigin( ).setType( IntersectionType.VALUE_LITERAL );

		// Y-Axis
		Axis yAxisPrimary = ( (ChartWithAxesImpl) cwaScatter ).getPrimaryOrthogonalAxis( xAxisPrimary );
		yAxisPrimary.getLabel( )
				.getCaption( )
				.setColor( ColorDefinitionImpl.BLUE( ) );
		yAxisPrimary.setType( AxisType.LINEAR_LITERAL );

		yAxisPrimary.getMajorGrid( ).setTickStyle( TickStyle.LEFT_LITERAL );
		yAxisPrimary.getMajorGrid( )
				.getLineAttributes( )
				.setStyle( LineStyle.DOTTED_LITERAL );
		yAxisPrimary.getMajorGrid( )
				.getLineAttributes( )
				.setColor( ColorDefinitionImpl.GREY( ) );
		yAxisPrimary.getMajorGrid( ).getLineAttributes( ).setVisible( true );

		yAxisPrimary.getOrigin( ).setType( IntersectionType.VALUE_LITERAL );

		// Data Set
		NumberDataSet dsNumericValues1 = NumberDataSetImpl.create( new double[]{
				25.32, 84.46, 125.95, 38.65, -54.32, 30
		} );
		NumberDataSet dsNumericValues2 = NumberDataSetImpl.create( new double[]{
				352.95, -201.95, 299.95, -95.95, 65.95, 58.95
		} );
		
		SampleData sd = DataFactory.eINSTANCE.createSampleData( );
		BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData( );
		sdBase.setDataSetRepresentation( "" );//$NON-NLS-1$
		sd.getBaseSampleData( ).add( sdBase );

		OrthogonalSampleData sdOrthogonal = DataFactory.eINSTANCE.createOrthogonalSampleData( );
		sdOrthogonal.setDataSetRepresentation( "" );//$NON-NLS-1$
		sdOrthogonal.setSeriesDefinitionIndex( 0 );
		sd.getOrthogonalSampleData( ).add( sdOrthogonal );
		
		cwaScatter.setSampleData( sd );

		// X-Series
		Series seBase = SeriesImpl.create( );
		seBase.setDataSet( dsNumericValues1 );

		SeriesDefinition sdX = SeriesDefinitionImpl.create( );
		xAxisPrimary.getSeriesDefinitions( ).add( sdX );
		sdX.getSeries( ).add( seBase );

		// Y-Series
		ScatterSeries ss = (ScatterSeries) ScatterSeriesImpl.create( );
		for ( int i = 0; i < ss.getMarkers( ).size( ); i++ )
		{
			( (Marker) ss.getMarkers( ).get( i ) ).setType( MarkerType.CIRCLE_LITERAL );
		}
		DataPoint dp = ss.getDataPoint( );
		dp.getComponents( ).clear( );
		dp.setPrefix( "(" );//$NON-NLS-1$
		dp.setSuffix( ")" );//$NON-NLS-1$
		dp.getComponents( )
				.add( DataPointComponentImpl.create( DataPointComponentType.BASE_VALUE_LITERAL,
						JavaNumberFormatSpecifierImpl.create( "0.00" ) ) );//$NON-NLS-1$
		dp.getComponents( )
				.add( DataPointComponentImpl.create( DataPointComponentType.ORTHOGONAL_VALUE_LITERAL,
						JavaNumberFormatSpecifierImpl.create( "0.00" ) ) );//$NON-NLS-1$
		ss.getLabel( ).getCaption( ).setColor( ColorDefinitionImpl.RED( ) );
		ss.getLabel( ).setBackground( ColorDefinitionImpl.CYAN( ) );
		ss.getLabel( ).setVisible( true );
		ss.setDataSet( dsNumericValues2 );

		SeriesDefinition sdY = SeriesDefinitionImpl.create( );
		yAxisPrimary.getSeriesDefinitions( ).add( sdY );
		sdY.getSeriesPalette( ).update( ColorDefinitionImpl.BLACK( ) );
		sdY.getSeries( ).add( ss );

		return cwaScatter;
	}

}
