/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.List;
import javax.olap.OLAPException;
import org.eclipse.birt.data.engine.olap.cursor.DimensionTraverse;
import org.eclipse.birt.data.engine.olap.cursor.EdgeDimensionRelation;
import org.eclipse.birt.data.engine.olap.cursor.EdgeInfo;
import org.eclipse.birt.data.engine.olap.cursor.EdgeTraverse;
import org.eclipse.birt.data.engine.olap.cursor.IRowDataAccessor;
import org.eclipse.birt.data.engine.olap.cursor.ResultSetFetcher;
import org.eclipse.birt.data.engine.olap.cursor.RowDataAccessorService;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.DimensionAxis;

public class RowDataAccessor
implements IRowDataAccessor {
    private IAggregationResultSet rs;
    protected DimensionAxis[] dimAxis;
    protected DimensionTraverse dimTraverse;
    protected EdgeTraverse edgeTraverse;
    protected EdgeDimensionRelation edgeDimensRelation;
    private RowDataAccessorService service;

    public RowDataAccessor(RowDataAccessorService service, IAggregationResultSet rs) {
        if (service.getDimensionAxis().length == 0) {
            return;
        }
        this.service = service;
        this.rs = rs;
        this.dimAxis = service.getDimensionAxis();
    }

    @Override
    public IAggregationResultSet getAggregationResultSet() {
        return this.rs;
    }

    @Override
    public void initialize(boolean isPage) throws IOException {
        ResultSetFetcher fetcher = new ResultSetFetcher(this.rs);
        this.edgeDimensRelation = new EdgeDimensionRelation(this.service, fetcher, isPage);
        this.dimTraverse = new DimensionTraverse(this.dimAxis, this.edgeDimensRelation);
        this.edgeTraverse = new EdgeTraverse(this.edgeDimensRelation);
    }

    @Override
    public boolean dim_next(int dimAxisIndex) throws OLAPException {
        return this.dimTraverse.next(dimAxisIndex);
    }

    @Override
    public boolean dim_previous(int dimAxisIndex) throws OLAPException {
        return this.dimTraverse.previous(dimAxisIndex);
    }

    @Override
    public boolean dim_relative(int offset, int dimAxisIndex) throws OLAPException {
        return this.dimTraverse.relative(offset, dimAxisIndex);
    }

    @Override
    public boolean dim_first(int dimAxisIndex) {
        return this.dimTraverse.first(dimAxisIndex);
    }

    @Override
    public boolean dim_last(int dimAxisIndex) {
        return this.dimTraverse.last(dimAxisIndex);
    }

    @Override
    public boolean dim_isBeforeFirst(int dimAxisIndex) {
        return this.dimTraverse.isBeforeFirst(dimAxisIndex);
    }

    @Override
    public boolean dim_isAfterLast(int dimAxisIndex) {
        return this.dimTraverse.isAfterLast(dimAxisIndex);
    }

    @Override
    public boolean dim_isFirst(int dimAxisIndex) {
        return this.dimTraverse.isFirst(dimAxisIndex);
    }

    @Override
    public boolean dim_isLast(int dimAxisIndex) {
        return this.dimTraverse.isLast(dimAxisIndex);
    }

    @Override
    public void dim_afterLast(int dimAxisIndex) {
        this.dimTraverse.afterLast(dimAxisIndex);
    }

    @Override
    public void dim_beforeFirst(int dimAxisIndex) {
        this.dimTraverse.beforeFirst(dimAxisIndex);
    }

    @Override
    public void dim_setPosition(int dimAxisIndex, long position) {
        this.dimTraverse.setPosition(dimAxisIndex, position);
    }

    @Override
    public long dim_getPosition(int dimAxisIndex) {
        return this.dimTraverse.getPosition(dimAxisIndex);
    }

    @Override
    public Object dim_getCurrentMember(int dimAxisIndex, int attr) throws OLAPException {
        try {
            int position = this.dimTraverse.getCurrentRowPosition(dimAxisIndex);
            if (position == -1) {
                throw new OLAPException("data.engine.GetLevelMemberError");
            }
            this.rs.seek(position);
        }
        catch (IOException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
        return this.dimTraverse.getCurrentMember(dimAxisIndex, attr);
    }

    @Override
    public Object dim_getCurrentMember(int dimAxisIndex, String attrName) throws OLAPException {
        try {
            int position = this.dimTraverse.getCurrentRowPosition(dimAxisIndex);
            if (position == -1) {
                throw new OLAPException("data.engine.GetLevelMemberError");
            }
            this.rs.seek(position);
        }
        catch (IOException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
        return this.dimTraverse.getCurrentMember(dimAxisIndex, attrName);
    }

    @Override
    public void edge_afterLast() {
        this.edgeTraverse.afterLast();
        int[] lastDimLength = this.getLastDiemsionLength();
        int i = 0;
        while (i < this.dimAxis.length) {
            this.dimTraverse.dimensionCursorPosition[i] = lastDimLength[i];
            ++i;
        }
    }

    @Override
    public void edge_beforeFirst() {
        this.edgeTraverse.beforeFirst();
        this.dimTraverse.beforeFirst();
    }

    @Override
    public boolean edge_first() {
        if (this.edgeTraverse.first()) {
            this.dimTraverse.first();
            return true;
        }
        return false;
    }

    @Override
    public long getEdgePostion() {
        if (this.edgeTraverse == null) {
            return -1L;
        }
        return this.edgeTraverse.getEdgePostion();
    }

    @Override
    public boolean edge_isAfterLast() {
        return this.edgeTraverse.isAfterLast();
    }

    @Override
    public boolean edge_isBeforeFirst() {
        return this.edgeTraverse.isBeforeFirst();
    }

    @Override
    public boolean edge_isFirst() {
        return this.edgeTraverse.isFirst();
    }

    @Override
    public boolean edge_isLast() {
        return this.edgeTraverse.isLast();
    }

    @Override
    public boolean edge_last() {
        if (this.edgeTraverse.last()) {
            int[] lastDimLength = this.getLastDiemsionLength();
            int i = 0;
            while (i < this.dimAxis.length) {
                this.dimTraverse.dimensionCursorPosition[i] = lastDimLength[i] - 1;
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean edge_next() throws OLAPException {
        if (!this.edgeTraverse.next()) {
            this.edge_afterLast();
            return false;
        }
        if (this.dimTraverse.isInitialStatus()) {
            int i = this.dimAxis.length - 1;
            while (i >= 0) {
                this.dimTraverse.first(i);
                --i;
            }
        } else {
            int i = this.dimAxis.length - 1;
            while (i >= 0) {
                if (!this.dimTraverse.next(i)) {
                    this.dimTraverse.first(i);
                    --i;
                    continue;
                }
                break;
            }
        }
        return true;
    }

    @Override
    public boolean edge_previous() throws OLAPException {
        this.edgeTraverse.previous();
        if (this.edgeTraverse.currentPosition >= this.edgeDimensRelation.traverseLength - 1) {
            int i = 0;
            while (i < this.dimAxis.length) {
                this.dimTraverse.previous(i);
                ++i;
            }
            return true;
        }
        if (this.edgeTraverse.currentPosition >= 0) {
            int i = this.dimAxis.length - 1;
            while (i >= 0) {
                if (this.dimTraverse.previous(i)) {
                    int k = i + 1;
                    while (k < this.dimAxis.length) {
                        this.dimTraverse.last(k);
                        ++k;
                    }
                    break;
                }
                this.dimTraverse.first(i);
                --i;
            }
            return true;
        }
        this.edgeTraverse.currentPosition = -1;
        this.dimTraverse.beforeFirst();
        return false;
    }

    @Override
    public boolean edge_relative(int arg0) throws OLAPException {
        if (arg0 == 0) {
            return true;
        }
        int position = this.edgeTraverse.currentPosition + arg0;
        if (position >= this.edgeDimensRelation.traverseLength) {
            this.edge_afterLast();
            return false;
        }
        if (position < 0) {
            this.dimTraverse.beforeFirst();
            this.edgeTraverse.currentPosition = -1;
            return false;
        }
        this.edgeTraverse.currentPosition = position;
        this.adjustDimensionPosition(position);
        return true;
    }

    private void adjustDimensionPosition(int position) {
        int index = position;
        int i = this.dimAxis.length - 1;
        while (i >= 0) {
            List edgeInfoList = this.edgeDimensRelation.currentRelation[i];
            EdgeInfo edgeInfo = (EdgeInfo)edgeInfoList.get(index);
            int currentPosition = index;
            int dimPosition = 0;
            while (--currentPosition >= 0) {
                EdgeInfo previousInfo = (EdgeInfo)edgeInfoList.get(currentPosition);
                if (previousInfo.parent != edgeInfo.parent) break;
                ++dimPosition;
            }
            this.dimTraverse.setPosition(i, dimPosition);
            index = edgeInfo.parent;
            --i;
        }
    }

    @Override
    public void edge_setPostion(long position) throws OLAPException {
        if (position < 0L) {
            this.dimTraverse.beforeFirst();
            this.edgeTraverse.currentPosition = -1;
            return;
        }
        int offSet = (int)position - this.edgeTraverse.currentPosition;
        this.edge_relative(offSet);
    }

    @Override
    public int getEdgeStart(int dimAxisIndex) {
        return this.dimTraverse.getEdgeStart(dimAxisIndex);
    }

    @Override
    public int getEdgeEnd(int dimAxisIndex) {
        return this.dimTraverse.getEdgeEnd(dimAxisIndex);
    }

    private int[] getLastDiemsionLength() {
        int[] lastDimensionLength = new int[this.dimAxis.length];
        int i = 0;
        while (i < this.dimAxis.length) {
            lastDimensionLength[i] = this.getRangeInLastDimension(i);
            ++i;
        }
        return lastDimensionLength;
    }

    private int getRangeInLastDimension(int dimIndex) {
        if (dimIndex == 0) {
            return this.edgeDimensRelation.currentRelation[0].size();
        }
        int size = this.edgeDimensRelation.currentRelation[dimIndex].size();
        if (size == 0) {
            return -1;
        }
        int count = 1;
        EdgeInfo edgeInfo = (EdgeInfo)this.edgeDimensRelation.currentRelation[dimIndex].get(size - 1);
        int i = size - 2;
        while (i >= 0) {
            EdgeInfo previousInfo = (EdgeInfo)this.edgeDimensRelation.currentRelation[dimIndex].get(i);
            if (previousInfo.parent == edgeInfo.parent) {
                ++count;
            }
            --i;
        }
        return count;
    }

    @Override
    public void sychronizedWithPage(int position) {
        this.edgeDimensRelation.synchronizedWithPage(position);
        this.dimTraverse = new DimensionTraverse(this.service.getDimensionAxis(), this.edgeDimensRelation);
        this.edgeTraverse = new EdgeTraverse(this.edgeDimensRelation);
        this.edge_beforeFirst();
    }

    @Override
    public RowDataAccessorService getRowDataAccessorService() {
        return this.service;
    }

    @Override
    public int getExtend(int dimAxisIndex) {
        return this.dimTraverse.getExtend(dimAxisIndex);
    }
}

