/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.launcher.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;

public class ReportLauncherUtils {
    public static HashMap getAutoStartPlugins(ILaunchConfiguration config) {
        boolean useDefault = true;
        String customAutoStart = "";
        try {
            useDefault = config.getAttribute("useDefaultConfig", true);
            customAutoStart = config.getAttribute("autoStartList", "");
        }
        catch (CoreException coreException) {}
        return ReportLauncherUtils.getAutoStartPlugins(useDefault, customAutoStart);
    }

    public static IPath getEclipseHome() {
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        return new Path(preferences.getString("platform_path"));
    }

    public static HashMap getAutoStartPlugins(boolean useDefault, String customAutoStart) {
        HashMap<String, Integer> list = new HashMap<String, Integer>();
        list.put("org.eclipse.core.boot", 0);
        return list;
    }

    public static Properties getConfigIniProperties(String directory, String filename) {
        File iniFile = new File(directory, filename);
        if (!iniFile.exists()) {
            return null;
        }
        Properties pini = new Properties();
        try {
            FileInputStream fis = new FileInputStream(iniFile);
            pini.load(fis);
            fis.close();
            return pini;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String getOSGiPath() {
        ModelEntry entry = PDECore.getDefault().getModelManager().findEntry("org.eclipse.osgi");
        if (entry != null && entry.getActiveModels().length > 0) {
            IPluginModelBase model = entry.getActiveModels()[0];
            if (model.getUnderlyingResource() != null) {
                return model.getUnderlyingResource().getLocation().removeLastSegments(2).toOSString();
            }
            return model.getInstallLocation();
        }
        return null;
    }

    private static Integer getStartLevel(String text) {
        StringTokenizer tok = new StringTokenizer(text, ":");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            try {
                return new Integer(token);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }

    public static String getPrimaryFeatureId() {
        boolean isOSGi = true;
        String filename = isOSGi ? "configuration/config.ini" : "install.ini";
        Properties properties = ReportLauncherUtils.getConfigIniProperties(ReportLauncherUtils.getEclipseHome().toOSString(), filename);
        String property = isOSGi ? "eclipse.product" : "feature.default.id";
        return properties == null ? null : properties.getProperty(property);
    }

    public static File createConfigArea(String name) {
        IPath statePath = PDECore.getDefault().getStateLocation();
        File dir = new File(statePath.toOSString());
        if (name.length() > 0 && !(dir = new File(dir, name)).exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static TreeSet parseDeselectedWSIds(ILaunchConfiguration config) throws CoreException {
        TreeSet<String> deselected = new TreeSet<String>();
        String ids = config.getAttribute("importproject", null);
        if (ids != null && ids.length() > 0) {
            StringTokenizer token = new StringTokenizer(ids, ";");
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                int index = str.lastIndexOf(File.separator);
                if (index > 0) {
                    str = str.substring(index + 1);
                }
                deselected.add(str);
            }
        }
        return deselected;
    }

    public static TreeSet parseDeselectedOpenFileNames(ILaunchConfiguration config) throws CoreException {
        TreeSet<String> deselected = new TreeSet<String>();
        String ids = config.getAttribute("openfilenames", null);
        if (ids != null && ids.length() > 0) {
            StringTokenizer token = new StringTokenizer(ids, ";");
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                int index = str.lastIndexOf(File.separator);
                if (index > 0) {
                    str = str.substring(index + 1);
                }
                deselected.add(str);
            }
        }
        return deselected;
    }

    public static TreeSet parseDeselectedClassIds(ILaunchConfiguration config) throws CoreException {
        TreeSet<String> deselected = new TreeSet<String>();
        String ids = config.getAttribute("importprojectnames", null);
        if (ids != null && ids.length() > 0) {
            StringTokenizer token = new StringTokenizer(ids, ";");
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                int index = str.lastIndexOf(File.separator);
                if (index > 0) {
                    str = str.substring(index + 1);
                }
                deselected.add(str);
            }
        }
        return deselected;
    }

    public static IVMInstall getVMInstall(String name) {
        if (name != null) {
            IVMInstall[] installs = ReportLauncherUtils.getAllVMInstances();
            int i = 0;
            while (i < installs.length) {
                if (installs[i].getName().equals(name)) {
                    return installs[i];
                }
                ++i;
            }
        }
        return JavaRuntime.getDefaultVMInstall();
    }

    public static IVMInstall[] getAllVMInstances() {
        ArrayList<IVMInstall> res = new ArrayList<IVMInstall>();
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstall[] installs = types[i].getVMInstalls();
            int k = 0;
            while (k < installs.length) {
                res.add(installs[k]);
                ++k;
            }
            ++i;
        }
        return res.toArray(new IVMInstall[res.size()]);
    }
}

