/*
 *************************************************************************
 * Copyright (c) 2005 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *  
 *************************************************************************
 */ 
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.script.IDataRow;
import org.eclipse.birt.report.engine.api.script.IUpdatableDataSetRow;
import org.eclipse.birt.report.engine.api.script.ScriptException;

public class UpdatableDataSetRow extends DataSetRow implements IUpdatableDataSetRow
{
	UpdatableDataSetRow(IDataRow row)
	{
		super(row);
	}
	
	public void setColumnValue( int index, Object value )
		throws ScriptException
	{
		try
		{
			row.setColumnValue( index, value );
		} catch ( BirtException e )
		{
			throw new ScriptException( e.getLocalizedMessage( ) );
		}
	}
	
	public void setColumnValue( String name, Object value ) throws ScriptException
	{
		try
		{
			row.setColumnValue( name, value );
		} catch ( BirtException e )
		{
			throw new ScriptException( e.getLocalizedMessage( ) );
		}
	}

}
