/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.IValue;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.model.RuleFactory;
import org.eclipse.bpel.validator.model.Validator;
import org.eclipse.bpel.validator.rules.CValidator;

public class QueryValidator
extends CValidator {
    public static IFilter<INode> PARENTS = new NodeNameFilter(ND_FROM, ND_TO);
    protected Validator fQueryValidator = null;
    protected String fQueryLanguage;

    @Override
    protected void start() {
        super.start();
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="Checks the query language for support in the BPEL model", date="10/2/2006", sa=4, errors="BPELC__UNSUPPORTED_XML_LANG")
    public void rule_CheckQueryLanguageSupport_20() {
        this.fQueryLanguage = this.getLanguage(this.mNode, AT_QUERYLANGUAGE);
        if (!this.mModelQuery.hasSupport(0, this.fQueryLanguage)) {
            IProblem problem = this.createError();
            problem.fill("BPELC__UNSUPPORTED_XML_LANG", AT_QUERYLANGUAGE, this.fQueryLanguage);
            this.disableRules();
            return;
        }
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="Checks the actual query using the query language validator.", date="10/2/2006", sa=1000, warnings="BPELC__NO_EXPRESSION_VALIDATOR")
    public void rule_CheckQuery_30() {
        QName qname = new QName(this.fQueryLanguage, this.mNode.nodeName().getLocalPart());
        if (this.fQueryValidator == null) {
            this.fQueryValidator = RuleFactory.INSTANCE.createValidator(qname);
            if (this.fQueryValidator == null) {
                IProblem problem = this.createWarning();
                problem.fill("BPELC__NO_EXPRESSION_VALIDATOR", this.toString(this.mNode.nodeName()), this.fQueryValidator);
                return;
            }
            this.attach(this.fQueryValidator);
        }
        this.setValue("expression.type", this.getValue(this.fParentNode, "type", null));
        this.setValue(this.fParentNode, "type", new IValue<Object>(){

            @Override
            public Object get() {
                return QueryValidator.this.fQueryValidator.getValue("expression.type");
            }
        });
    }
}

