/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.build;

import java.util.HashMap;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.ICBuildConfigurationProvider;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.internal.qt.core.build.QtBuildConfiguration;
import org.eclipse.cdt.qt.core.IQtBuildConfiguration;
import org.eclipse.cdt.qt.core.IQtInstall;
import org.eclipse.cdt.qt.core.IQtInstallManager;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class QtBuildConfigurationProvider
implements ICBuildConfigurationProvider {
    public static final String ID = "org.eclipse.cdt.qt.core.qtBuildConfigProvider";
    private IToolChainManager toolChainManager = Activator.getService(IToolChainManager.class);
    private IQtInstallManager qtInstallManager = Activator.getService(IQtInstallManager.class);
    private ICBuildConfigurationManager configManager = Activator.getService(ICBuildConfigurationManager.class);

    public String getId() {
        return ID;
    }

    public ICBuildConfiguration getCBuildConfiguration(IBuildConfiguration config, String name) {
        block7: {
            try {
                if (!config.getName().equals("")) break block7;
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("os", Platform.getOS());
                properties.put("arch", Platform.getOSArch());
                for (IToolChain toolChain : this.toolChainManager.getToolChainsMatching(properties)) {
                    for (IQtInstall qtInstall : this.qtInstallManager.getInstalls()) {
                        if (!this.qtInstallManager.supports(qtInstall, toolChain)) continue;
                        return new QtBuildConfiguration(config, name, toolChain, qtInstall, null);
                    }
                }
                for (IToolChain toolChain : this.toolChainManager.getToolChainsMatching(new HashMap())) {
                    for (IQtInstall qtInstall : this.qtInstallManager.getInstalls()) {
                        if (!this.qtInstallManager.supports(qtInstall, toolChain)) continue;
                        return new QtBuildConfiguration(config, name, toolChain, qtInstall, null);
                    }
                }
                return null;
            }
            catch (CoreException e) {
                Activator.log(e);
                return null;
            }
        }
        return new QtBuildConfiguration(config, name);
    }

    public ICBuildConfiguration createBuildConfiguration(IProject project, IToolChain toolChain, String launchMode, IProgressMonitor monitor) throws CoreException {
        IQtInstall qtInstall = this.getQtInstall(toolChain);
        if (qtInstall != null) {
            IBuildConfiguration[] iBuildConfigurationArray = project.getBuildConfigs();
            int n = iBuildConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IQtBuildConfiguration qtConfig;
                IBuildConfiguration config = iBuildConfigurationArray[n2];
                ICBuildConfiguration cconfig = (ICBuildConfiguration)config.getAdapter(ICBuildConfiguration.class);
                if (cconfig != null && (qtConfig = (IQtBuildConfiguration)cconfig.getAdapter(IQtBuildConfiguration.class)) != null && launchMode.equals(qtConfig.getLaunchMode()) && qtConfig.getToolChain().equals(toolChain)) {
                    return qtConfig;
                }
                ++n2;
            }
            String configName = "qt." + qtInstall.getSpec() + "." + launchMode;
            IBuildConfiguration config = this.configManager.createBuildConfiguration((ICBuildConfigurationProvider)this, project, configName, monitor);
            QtBuildConfiguration qtConfig = new QtBuildConfiguration(config, configName, toolChain, qtInstall, launchMode);
            this.configManager.addBuildConfiguration(config, (ICBuildConfiguration)qtConfig);
            return qtConfig;
        }
        return null;
    }

    private IQtInstall getQtInstall(IToolChain toolChain) {
        for (IQtInstall qtInstall : this.qtInstallManager.getInstalls()) {
            if (!this.qtInstallManager.supports(qtInstall, toolChain)) continue;
            return qtInstall;
        }
        return null;
    }
}

