/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.refactoring;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileDeleteChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class ConnectionProfileDeleteProcessor
extends DeleteProcessor {
    public static final String PROCESSOR_ID = "org.eclipse.datatools.connectivity.ui.deleteProcessor";
    private IConnectionProfile mProfile;

    public ConnectionProfileDeleteProcessor(IConnectionProfile profile) {
        this.mProfile = profile;
    }

    public Object[] getElements() {
        return new Object[]{this.mProfile};
    }

    public String getIdentifier() {
        return PROCESSOR_ID;
    }

    public String getProcessorName() {
        return MessageFormat.format(ConnectivityUIPlugin.getDefault().getResourceString("CPDeleteChange.name"), this.mProfile.getName());
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new ConnectionProfileDeleteChange(this.mProfile, new DeleteArguments());
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        ArrayList<DeleteParticipant> participants = new ArrayList<DeleteParticipant>();
        participants.addAll(Arrays.asList(ParticipantManager.loadDeleteParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.mProfile, (DeleteArguments)new DeleteArguments(), (String[])new String[0], (SharableParticipants)sharedParticipants)));
        return participants.toArray(new RefactoringParticipant[participants.size()]);
    }

    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }
}

