/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.indexdiff;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.core.internal.SafeRunnable;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffChangedListener;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;

public class IndexDiffCache {
    private Map<File, IndexDiffCacheEntry> entries = new HashMap<File, IndexDiffCacheEntry>();
    private CopyOnWriteArrayList<IndexDiffChangedListener> listeners = new CopyOnWriteArrayList();
    private IndexDiffChangedListener globalListener;
    private ExternalFileBufferListener bufferListener;

    public IndexDiffCache() {
        this.createGlobalListener();
        this.registerBufferListener();
    }

    private void registerBufferListener() {
        this.bufferListener = new ExternalFileBufferListener();
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        if (bufferManager != null) {
            bufferManager.addFileBufferListener((IFileBufferListener)this.bufferListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IndexDiffCacheEntry getIndexDiffCacheEntry(@NonNull Repository repository) {
        IndexDiffCacheEntry entry;
        Map<File, IndexDiffCacheEntry> map = this.entries;
        synchronized (map) {
            File gitDir;
            block5: {
                gitDir = new Path(repository.getDirectory().getAbsolutePath()).toFile();
                entry = this.entries.get(gitDir);
                if (entry != null) {
                    return entry;
                }
                if (!repository.isBare()) break block5;
                return null;
            }
            entry = new IndexDiffCacheEntry(repository, this.globalListener);
            this.entries.put(gitDir, entry);
        }
        return entry;
    }

    public void addIndexDiffChangedListener(IndexDiffChangedListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeIndexDiffChangedListener(IndexDiffChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void createGlobalListener() {
        this.globalListener = new IndexDiffChangedListener(){

            @Override
            public void indexDiffChanged(Repository repository, IndexDiffData indexDiffData) {
                IndexDiffCache.this.notifyListeners(repository, indexDiffData);
            }
        };
    }

    private void notifyListeners(Repository repository, IndexDiffData indexDiffData) {
        for (IndexDiffChangedListener listener : this.listeners) {
            SafeRunnable.run(() -> listener.indexDiffChanged(repository, indexDiffData));
        }
    }

    public void dispose() {
        ITextFileBufferManager bufferManager;
        if (this.bufferListener != null && (bufferManager = FileBuffers.getTextFileBufferManager()) != null) {
            bufferManager.removeFileBufferListener((IFileBufferListener)this.bufferListener);
            this.bufferListener = null;
        }
        for (IndexDiffCacheEntry entry : this.entries.values()) {
            entry.dispose();
        }
        Job.getJobManager().cancel(JobFamilies.INDEX_DIFF_CACHE_UPDATE);
        try {
            Job.getJobManager().join(JobFamilies.INDEX_DIFF_CACHE_UPDATE, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NonNull File gitDir) {
        Map<File, IndexDiffCacheEntry> map = this.entries;
        synchronized (map) {
            IndexDiffCacheEntry cachedEntry = this.entries.remove(gitDir);
            if (cachedEntry != null) {
                cachedEntry.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Set<File> currentCacheEntries() {
        HashSet<File> result = null;
        Map<File, IndexDiffCacheEntry> map = this.entries;
        synchronized (map) {
            result = new HashSet<File>(this.entries.keySet());
        }
        return result;
    }

    class ExternalFileBufferListener
    implements IFileBufferListener {
        ExternalFileBufferListener() {
        }

        private void updateRepoState(IFileBuffer buffer) {
            IFile file = this.getResource(buffer);
            if (file != null) {
                return;
            }
            Repository repo = this.getRepository(buffer);
            if (repo == null || repo.isBare()) {
                return;
            }
            IPath relativePath = this.getRelativePath(repo, buffer);
            if (relativePath == null || relativePath.isEmpty()) {
                return;
            }
            IndexDiffCacheEntry diffEntry = IndexDiffCache.this.getIndexDiffCacheEntry(repo);
            if (diffEntry != null) {
                if (".gitignore".equals(relativePath.lastSegment())) {
                    diffEntry.refresh();
                } else {
                    diffEntry.refreshFiles(Collections.singleton(relativePath.toString()));
                }
            }
        }

        @Nullable
        private IPath getRelativePath(Repository repo, IFileBuffer buffer) {
            IPath path = this.getPath(buffer);
            if (path == null) {
                return null;
            }
            Path repositoryRoot = new Path(repo.getWorkTree().getPath());
            return path.makeRelativeTo((IPath)repositoryRoot);
        }

        @Nullable
        private IFile getResource(IFileBuffer buffer) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IPath location = buffer.getLocation();
            if (location == null) {
                return null;
            }
            IFile file = root.getFile(location);
            if (!file.isAccessible()) {
                return null;
            }
            return file;
        }

        @Nullable
        private Repository getRepository(IFileBuffer buffer) {
            IPath location = this.getPath(buffer);
            if (location != null) {
                return Activator.getDefault().getRepositoryCache().getRepository(location);
            }
            return null;
        }

        @Nullable
        private IPath getPath(IFileBuffer buffer) {
            URI uri;
            IPath location = buffer.getLocation();
            if (location != null) {
                return location;
            }
            IFileStore store = buffer.getFileStore();
            if (store != null && (uri = store.toURI()) != null) {
                try {
                    File file = new File(uri);
                    return new Path(file.getAbsolutePath());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return null;
        }

        public void underlyingFileDeleted(IFileBuffer buffer) {
            this.updateRepoState(buffer);
        }

        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            if (!isDirty) {
                this.updateRepoState(buffer);
            }
        }

        public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
        }

        public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
        }

        public void stateChanging(IFileBuffer buffer) {
        }

        public void stateChangeFailed(IFileBuffer buffer) {
        }

        public void bufferDisposed(IFileBuffer buffer) {
        }

        public void bufferCreated(IFileBuffer buffer) {
        }

        public void bufferContentReplaced(IFileBuffer buffer) {
        }

        public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
        }
    }
}

