/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.synchronize.IgnoreInGitSynchronizations;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.team.core.RepositoryProvider;

public class ResourceUtil {
    private static final QualifiedName PROVIDER_PROP_KEY = new QualifiedName("org.eclipse.team.core", "repository");
    private static final QualifiedName PROVIDER_ID = new QualifiedName("org.eclipse.egit.core", "repositoryProviderID");
    private static final Object PROJECT_IS_UNSHARED = new Object();

    @Nullable
    public static IResource getResourceForLocation(@NonNull IPath location, boolean innerMost) {
        IFile file = ResourceUtil.getFileForLocation(location, innerMost);
        if (file != null) {
            return file;
        }
        return ResourceUtil.getContainerForLocation(location, innerMost);
    }

    @Nullable
    public static IFile getFileForLocation(@NonNull IPath location, boolean innerMost) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFileForLocation(location);
        if (file == null) {
            return null;
        }
        if (!innerMost && ResourceUtil.isValid((IResource)file)) {
            return file;
        }
        URI uri = URIUtil.toURI((IPath)location);
        IFile file2 = ResourceUtil.getFileForLocationURI(root, uri);
        if (file2 == null && ResourceUtil.isValid((IResource)file)) {
            return file;
        }
        return file2;
    }

    private static boolean isValid(@NonNull IResource resource) {
        return resource.isAccessible() && !resource.isLinked(512) && ResourceUtil.isSharedWithGit(resource);
    }

    public static boolean isSharedWithGit(@NonNull IResource resource) {
        IProject project;
        block9: {
            block8: {
                project = resource.getProject();
                if (project == null || !project.isAccessible()) {
                    return false;
                }
                try {
                    GitProvider provider = ResourceUtil.lookupProviderProp(project);
                    if (provider == null && !MappingJob.isKnownGitProject(project)) break block8;
                    return true;
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                    return false;
                }
            }
            if (!ResourceUtil.isMarkedAsNotSharedWithGit(project)) break block9;
            return false;
        }
        String existingID = project.getPersistentProperty(PROVIDER_PROP_KEY);
        if (existingID == null) {
            ResourceUtil.markAsUnshared(project);
        } else {
            ResourceUtil.markAsShared(project, existingID);
        }
        boolean isGitProvider = "org.eclipse.egit.core.GitProvider".equals(existingID);
        if (isGitProvider) {
            MappingJob.initProviderAsynchronously(project);
        }
        return isGitProvider;
    }

    @Nullable
    public static final GitProvider getGitProvider(@NonNull IProject project) {
        block8: {
            if (!project.isAccessible()) {
                return null;
            }
            try {
                GitProvider provider = ResourceUtil.lookupProviderProp(project);
                if (provider != null) {
                    return provider;
                }
                if (!MappingJob.isKnownGitProject(project) && !ResourceUtil.isMarkedAsNotSharedWithGit(project)) break block8;
                return null;
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
                return null;
            }
        }
        String existingID = project.getPersistentProperty(PROVIDER_PROP_KEY);
        if (existingID == null) {
            ResourceUtil.markAsUnshared(project);
        } else {
            ResourceUtil.markAsShared(project, existingID);
            boolean isGitProvider = "org.eclipse.egit.core.GitProvider".equals(existingID);
            if (isGitProvider) {
                MappingJob.initProviderAsynchronously(project);
            }
        }
        return null;
    }

    @Nullable
    private static GitProvider lookupProviderProp(IProject project) throws CoreException {
        Object provider = project.getSessionProperty(PROVIDER_PROP_KEY);
        if (provider != null) {
            if (provider instanceof RepositoryProvider) {
                ResourceUtil.markAsShared(project, ((RepositoryProvider)provider).getID());
                if (provider instanceof GitProvider) {
                    return (GitProvider)((Object)provider);
                }
            } else {
                ResourceUtil.markAsUnshared(project);
            }
        }
        return null;
    }

    private static void markAsUnshared(@NonNull IProject project) {
        try {
            project.setSessionProperty(PROVIDER_ID, PROJECT_IS_UNSHARED);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private static void markAsShared(@NonNull IProject project, @Nullable String providerId) {
        try {
            project.setSessionProperty(PROVIDER_ID, (Object)providerId);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private static boolean isMarkedAsNotSharedWithGit(@NonNull IProject project) {
        Object property;
        block4: {
            property = project.getSessionProperty(PROVIDER_ID);
            if (property != PROJECT_IS_UNSHARED) break block4;
            return true;
        }
        try {
            if (property instanceof String && !"org.eclipse.egit.core.GitProvider".equals(property)) {
                return true;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    @Nullable
    public static IContainer getContainerForLocation(@NonNull IPath location, boolean innerMost) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer dir = root.getContainerForLocation(location);
        if (dir == null) {
            return null;
        }
        if (!innerMost && ResourceUtil.isValid((IResource)dir)) {
            return dir;
        }
        URI uri = URIUtil.toURI((IPath)location);
        IContainer dir2 = ResourceUtil.getContainerForLocationURI(root, uri);
        if (dir2 == null && ResourceUtil.isValid((IResource)dir)) {
            return dir;
        }
        return dir2;
    }

    @Nullable
    public static IFile getFileForLocation(@NonNull Repository repository, @NonNull String repoRelativePath, boolean innerMost) {
        IPath path = new Path(repository.getWorkTree().getAbsolutePath()).append(repoRelativePath);
        return ResourceUtil.getFileForLocation(path, innerMost);
    }

    @Nullable
    public static IContainer getContainerForLocation(@NonNull Repository repository, @NonNull String repoRelativePath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = new Path(repository.getWorkTree().getAbsolutePath()).append(repoRelativePath);
        return root.getContainerForLocation(path);
    }

    public static boolean isSymbolicLink(@NonNull Repository repository, @NonNull String repoRelativePath) {
        try {
            File f = new Path(repository.getWorkTree().getAbsolutePath()).append(repoRelativePath).toFile();
            return FS.DETECTED.isSymLink(f);
        }
        catch (IOException e) {
            return false;
        }
    }

    @NonNull
    public static IResource getResourceHandleForLocation(@NonNull IPath path) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Object resource = path.segmentCount() > 1 ? workspaceRoot.getFile(path) : workspaceRoot.getProject(path.toString());
        return resource;
    }

    public static Map<Repository, Collection<String>> splitResourcesByRepository(Collection<IResource> resources) {
        HashMap<Repository, Collection<String>> result = new HashMap<Repository, Collection<String>>();
        for (IResource resource : resources) {
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping(resource);
            if (repositoryMapping == null) continue;
            String path = repositoryMapping.getRepoRelativePath(resource);
            ResourceUtil.addPathToMap(repositoryMapping.getRepository(), path, result);
        }
        return result;
    }

    public static Map<Repository, Collection<String>> splitResourcesByRepository(IResource[] resources) {
        return ResourceUtil.splitResourcesByRepository(Arrays.asList(resources));
    }

    public static Map<Repository, Collection<String>> splitPathsByRepository(Collection<IPath> paths) {
        RepositoryCache repositoryCache = Activator.getDefault().getRepositoryCache();
        HashMap<Repository, Collection<String>> result = new HashMap<Repository, Collection<String>>();
        for (IPath path : paths) {
            Repository repository = repositoryCache.getRepository(path);
            if (repository == null) continue;
            Path repoPath = new Path(repository.getWorkTree().getAbsolutePath());
            IPath repoRelativePath = path.makeRelativeTo((IPath)repoPath);
            ResourceUtil.addPathToMap(repository, repoRelativePath.toString(), result);
        }
        return result;
    }

    public static boolean isNonWorkspace(@NonNull IResource resource) {
        return resource.getLocation() == null;
    }

    private static IFile getFileForLocationURI(@NonNull IWorkspaceRoot root, @NonNull URI uri) {
        IFile[] files = root.findFilesForLocationURI(uri);
        return (IFile)ResourceUtil.getExistingMappedResourceWithShortestPath((IResource[])files);
    }

    private static IContainer getContainerForLocationURI(IWorkspaceRoot root, @NonNull URI uri) {
        IContainer[] containers = root.findContainersForLocationURI(uri);
        return (IContainer)ResourceUtil.getExistingMappedResourceWithShortestPath((IResource[])containers);
    }

    private static <T extends IResource> T getExistingMappedResourceWithShortestPath(T[] resources) {
        int shortestPathSegmentCount = Integer.MAX_VALUE;
        T shortestPath = null;
        T[] TArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IPath fullPath;
            int segmentCount;
            T resource = TArray[n2];
            if (resource.exists() && ResourceUtil.isSharedWithGit(resource) && (segmentCount = (fullPath = resource.getFullPath()).segmentCount()) < shortestPathSegmentCount) {
                shortestPath = resource;
                shortestPathSegmentCount = segmentCount;
            }
            ++n2;
        }
        return shortestPath;
    }

    private static void addPathToMap(@NonNull Repository repository, @Nullable String path, Map<Repository, Collection<String>> result) {
        if (path != null) {
            Collection<String> resourcesList = result.get(repository);
            if (resourcesList == null) {
                resourcesList = new ArrayList<String>();
                result.put(repository, resourcesList);
            }
            resourcesList.add(path);
        }
    }

    public static ResourceMapping[] getResourceMappings(@NonNull IResource resource, ResourceMappingContext context) {
        IModelProviderDescriptor[] modelDescriptors = ModelProvider.getModelProviderDescriptors();
        LinkedHashSet<ResourceMapping> mappings = new LinkedHashSet<ResourceMapping>();
        IModelProviderDescriptor[] iModelProviderDescriptorArray = modelDescriptors;
        int n = modelDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IModelProviderDescriptor candidate = iModelProviderDescriptorArray[n2];
            try {
                ModelProvider model;
                IgnoreInGitSynchronizations adapter;
                IResource[] resources = candidate.getMatchingResources(new IResource[]{resource});
                if (resources.length > 0 && (adapter = (IgnoreInGitSynchronizations)(model = candidate.getModelProvider()).getAdapter(IgnoreInGitSynchronizations.class)) == null) {
                    ResourceMapping[] modelMappings;
                    ResourceMapping[] resourceMappingArray = modelMappings = model.getMappings(resource, context, (IProgressMonitor)new NullProgressMonitor());
                    int n3 = modelMappings.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ResourceMapping mapping = resourceMappingArray[n4];
                        mappings.add(mapping);
                        ++n4;
                    }
                }
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
            }
            ++n2;
        }
        return mappings.toArray(new ResourceMapping[0]);
    }

    public static void saveLocalHistory(@NonNull Repository repository) {
        IndexDiffCacheEntry indexDiffCacheEntry = Activator.getDefault().getIndexDiffCache().getIndexDiffCacheEntry(repository);
        if (indexDiffCacheEntry == null) {
            return;
        }
        IndexDiffData indexDiffData = indexDiffCacheEntry.getIndexDiff();
        if (indexDiffData != null) {
            Collection<IResource> changedResources = indexDiffData.getChangedResources();
            for (IResource changedResource : changedResources) {
                if (!(changedResource instanceof IFile) || !changedResource.exists()) continue;
                try {
                    ResourceUtil.saveLocalHistory(changedResource);
                }
                catch (CoreException e) {
                    Activator.logError(MessageFormat.format(CoreText.ResourceUtil_SaveLocalHistoryFailed, changedResource), e);
                }
            }
        }
    }

    private static void saveLocalHistory(@NonNull IResource resource) throws CoreException {
        if (!resource.isSynchronized(0)) {
            resource.refreshLocal(0, null);
        }
        ((IFile)resource).appendContents((InputStream)new ByteArrayInputStream(new byte[0]), 2, null);
    }

    @Nullable
    public static Repository getRepository(@NonNull IResource resource) {
        RepositoryMapping mapping = RepositoryMapping.getMapping(resource);
        if (mapping != null) {
            return mapping.getRepository();
        }
        return Activator.getDefault().getRepositoryCache().getRepository(resource);
    }

    @Nullable
    public static Repository getRepository(@NonNull IPath path) {
        return Activator.getDefault().getRepositoryCache().getRepository(path);
    }

    @Nullable
    public static IPath getRepositoryRelativePath(@Nullable IPath path, @NonNull Repository repository) {
        if (path == null || repository.isBare()) {
            return null;
        }
        java.nio.file.Path workingDirectory = repository.getWorkTree().toPath();
        java.nio.file.Path toRelativize = path.toFile().toPath();
        if (toRelativize.startsWith(workingDirectory)) {
            int m;
            int n = workingDirectory.getNameCount();
            if (n == (m = toRelativize.getNameCount())) {
                return new Path("");
            }
            return Path.fromOSString((String)toRelativize.subpath(n, m).toString());
        }
        return null;
    }

    public static List<IResource> extractResourcesFromMapping(@Nullable ResourceMapping mapping) {
        ResourceTraversal[] traversals;
        if (mapping == null) {
            return Collections.emptyList();
        }
        try {
            traversals = mapping.getTraversals(null, null);
        }
        catch (CoreException e) {
            Activator.logError(e.getMessage(), e);
            return Collections.emptyList();
        }
        if (traversals.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IResource> result = new ArrayList<IResource>();
        ResourceTraversal[] resourceTraversalArray = traversals;
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal traversal = resourceTraversalArray[n2];
            IResource[] resources = traversal.getResources();
            result.addAll(Arrays.asList(resources));
            ++n2;
        }
        return result;
    }

    private static class MappingJob
    extends Job {
        private static final MappingJob INSTANCE = new MappingJob();
        HashSet<IProject> projects = new LinkedHashSet<IProject>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void initProviderAsynchronously(@NonNull IProject project) {
            HashSet<IProject> hashSet = MappingJob.INSTANCE.projects;
            synchronized (hashSet) {
                if (!MappingJob.INSTANCE.projects.add(project)) {
                    return;
                }
            }
            INSTANCE.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean isKnownGitProject(@NonNull IProject project) {
            HashSet<IProject> hashSet = MappingJob.INSTANCE.projects;
            synchronized (hashSet) {
                return MappingJob.INSTANCE.projects.contains(project);
            }
        }

        public MappingJob() {
            super(CoreText.ResourceUtil_mapProjectJob);
            this.setSystem(true);
            this.setUser(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            LinkedHashSet<IProject> work;
            HashSet<IProject> hashSet = this.projects;
            synchronized (hashSet) {
                work = new LinkedHashSet<IProject>(this.projects);
            }
            for (IProject project : work) {
                if (monitor.isCanceled()) break;
                RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.egit.core.GitProvider");
            }
            hashSet = this.projects;
            synchronized (hashSet) {
                if (monitor.isCanceled()) {
                    this.projects.clear();
                } else {
                    this.projects.removeAll(work);
                }
                if (!this.projects.isEmpty()) {
                    this.schedule();
                }
            }
            return Status.OK_STATUS;
        }
    }
}

