/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.column;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.custom.ui.IContentPropertiesHandler;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.util.emf.core.command.EmfCommandUtils;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.SourceColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TableFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TablePackage;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.column.ColumnComparator;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.BasicCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.CommandList;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.CustomizationUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.LocalCustomCommandFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnsCommandFactory {
    private final Table table;
    private final BasicCommandFactory basicCmdFactory;
    private final LocalCustomCommandFactory locCustCmdFactory;

    public ColumnsCommandFactory(Table table, BasicCommandFactory basicCmdFactory) {
        this.table = table;
        this.basicCmdFactory = basicCmdFactory;
        this.locCustCmdFactory = new LocalCustomCommandFactory(table, basicCmdFactory);
    }

    public Command createAddColumnCommand(List<ETypedElement> eTypedElements, Command signFacetSetCmd) {
        CommandList commandList = new CommandList();
        commandList.add(signFacetSetCmd);
        Command addColumn = this.createAddColumn(eTypedElements);
        commandList.add(addColumn);
        return EmfCommandUtils.createResult((List)commandList, (String)"Add columns and facetSets");
    }

    private Command createAddColumn(List<ETypedElement> eTypedElements) {
        CommandList commandList = new CommandList();
        for (ETypedElement eTypedElement : eTypedElements) {
            Command addColumn = this.createAddColumn(eTypedElement);
            commandList.add(addColumn);
        }
        return EmfCommandUtils.createResult((List)commandList, (String)"Add columns");
    }

    private Command createAddColumn(ETypedElement eTypedElement) {
        ETypedElement signature = eTypedElement;
        if (eTypedElement instanceof FacetOperation) {
            FacetOperation facetOperation = (FacetOperation)eTypedElement;
            signature = FacetUtils.getSignature((FacetOperation)facetOperation);
        }
        Column existingColumn = null;
        for (Column column : this.table.getColumns()) {
            FeatureColumn featureColumn;
            if (!(column instanceof FeatureColumn) || !(featureColumn = (FeatureColumn)column).getFeature().equals(signature)) continue;
            existingColumn = column;
            break;
        }
        CommandList commandList = new CommandList();
        if (existingColumn == null) {
            FeatureColumn column = TableFactory.eINSTANCE.createFeatureColumn();
            Command setColumn = this.basicCmdFactory.createAddCommand(this.table, TablePackage.eINSTANCE.getTable_Columns(), column);
            commandList.add(setColumn);
            Command setETypedElement = this.basicCmdFactory.createSetCommand(column, TablePackage.eINSTANCE.getFeatureColumn_Feature(), signature);
            commandList.add(setETypedElement);
        }
        return EmfCommandUtils.createResult((List)commandList, (String)"Add column");
    }

    public Command createRemoveColumnsCommand(List<ETypedElement> elements) {
        ArrayList<Command> commandList = new ArrayList<Command>();
        if (elements != null && !elements.isEmpty()) {
            for (Column column : this.table.getColumns()) {
                if (!(column instanceof FeatureColumn) || !elements.contains(((FeatureColumn)column).getFeature())) continue;
                FeatureColumn featureColumn = (FeatureColumn)column;
                Command rmCommand = this.createRemoveColumnCommand(featureColumn);
                commandList.add(rmCommand);
            }
        }
        String msg = String.format("Remove %s columms", commandList.size());
        return EmfCommandUtils.createResult(commandList, (String)msg);
    }

    private Command createRemoveColumnCommand(FeatureColumn featureColumn) {
        return this.basicCmdFactory.createRemoveCommand(this.table, TablePackage.eINSTANCE.getTable_Columns(), featureColumn);
    }

    public Command createShowHideColumnCommand(List<Column> columnToShow, List<Column> visibleColumns, boolean putOnTheTop) {
        Command cmd;
        ArrayList<Column> columnsToShow = new ArrayList<Column>();
        ArrayList<Column> columnsToHide = new ArrayList<Column>();
        EList columns = this.table.getColumns();
        for (Column c : columns) {
            boolean mustBeHidden;
            boolean bl = mustBeHidden = !columnToShow.contains(c);
            if (mustBeHidden != visibleColumns.contains(c)) continue;
            if (mustBeHidden) {
                columnsToHide.add(c);
                continue;
            }
            columnsToShow.add(c);
        }
        CommandList commandList = new CommandList();
        List<Command> columnToShowCmds = this.createColumnToShowCommands(columnsToShow);
        commandList.addAll(columnToShowCmds);
        HashSet<FeatureColumn> fColumnsToHide = new HashSet<FeatureColumn>();
        for (Column current : columnsToHide) {
            if (current instanceof FeatureColumn) {
                fColumnsToHide.add((FeatureColumn)current);
                continue;
            }
            Command cmd2 = this.basicCmdFactory.createSetCommand(current, TablePackage.eINSTANCE.getSourceColumn_IsHidden(), Boolean.TRUE);
            commandList.add(cmd2);
        }
        Command tmp = this.createHideColumnCommand(fColumnsToHide);
        if (tmp != null) {
            commandList.add(tmp);
        }
        if (putOnTheTop && (cmd = this.locCustCmdFactory.createPutLocalCustomizationOnTheTopCommand()).canExecute()) {
            commandList.add(cmd);
        }
        return EmfCommandUtils.createResult((List)commandList, (String)"Show/hide column");
    }

    public Command createHideColumnCommand(Collection<FeatureColumn> featureColumns) {
        IContentPropertiesHandler contentPropH = CustomizationUtils.getContentPropertiesHandler(this.table);
        FacetOperation isVisibleProperty = contentPropH.getIsVisible();
        HashSet<ETypedElement> featuresToHide = new HashSet<ETypedElement>();
        for (FeatureColumn column : featureColumns) {
            featuresToHide.add(column.getFeature());
        }
        return this.locCustCmdFactory.createCustomPropertyCommand("Show/hide column", isVisibleProperty, featuresToHide);
    }

    private List<Command> createColumnToShowCommands(List<Column> columnsToShow) {
        CommandList commandList = new CommandList();
        for (Column current : columnsToShow) {
            Command cmd;
            if (!(current instanceof SourceColumn) || !(cmd = this.basicCmdFactory.createSetCommand(current, TablePackage.eINSTANCE.getSourceColumn_IsHidden(), Boolean.FALSE)).canExecute()) continue;
            commandList.add(cmd);
        }
        return commandList;
    }

    public final Command createSetHideEmptyColumnsCommand(boolean hideEmptyColumns) {
        return this.basicCmdFactory.createSetCommand(this.table, TablePackage.eINSTANCE.getTable_HideEmptyColumns(), hideEmptyColumns);
    }

    public final Command createSetOnlyShowCommonColumnsCommand(boolean value) {
        return this.basicCmdFactory.createSetCommand(this.table, TablePackage.eINSTANCE.getTable_OnlyShowCommonColumns(), value);
    }

    public final Command createSortColumnsByTypeCommand() {
        int[] order = new int[this.table.getColumns().size()];
        int idx = 0;
        int j = 0;
        while (j < this.table.getColumns().size()) {
            Column columnDescription = (Column)this.table.getColumns().get(j);
            if (columnDescription instanceof SourceColumn || columnDescription instanceof FeatureColumn && ((FeatureColumn)columnDescription).getFeature() instanceof EAttribute) {
                order[idx++] = j;
            }
            ++j;
        }
        List<Integer> links = this.getPositionOfReferences();
        for (Integer linkPos : links) {
            order[idx++] = linkPos;
        }
        return this.createSortColumnsCommand(order);
    }

    private List<Integer> getPositionOfReferences() {
        ArrayList<Integer> links = new ArrayList<Integer>();
        int j = 0;
        while (j < this.table.getColumns().size()) {
            Column columnDescription = (Column)this.table.getColumns().get(j);
            if (columnDescription instanceof FeatureColumn && ((FeatureColumn)columnDescription).getFeature() instanceof EReference) {
                links.add(j);
            }
            ++j;
        }
        return links;
    }

    private Command createSortColumnsCommand(int[] order) {
        CompoundCommand compoundCommand = new CompoundCommand();
        int index = 0;
        while (index < order.length) {
            int pos = order[index];
            EObject element = (EObject)this.table.getColumns().get(pos);
            Command command = this.basicCmdFactory.createMoveCommand(this.table, TablePackage.eINSTANCE.getTable_Columns(), element, index);
            compoundCommand.append(command);
            ++index;
        }
        return compoundCommand;
    }

    public final Command createSortColumnByNameAtoZCommand() {
        return this.createSortColumnByLexicalOrderCommand(false);
    }

    public final Command createSortColumnByNameZtoACommand() {
        return this.createSortColumnByLexicalOrderCommand(true);
    }

    private final Command createSortColumnByLexicalOrderCommand(boolean inverseOrder) {
        ArrayList columns = new ArrayList(this.table.getColumns());
        ColumnComparator comparator = new ColumnComparator();
        comparator.setInversedOrder(inverseOrder);
        Collections.sort(columns, comparator);
        return this.basicCmdFactory.createSetCommand(this.table, TablePackage.eINSTANCE.getTable_Columns(), columns);
    }
}

