/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.emf.listener;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.emf.core.EmfDebugUtils;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.CannotExecuteCommandException;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.MultiModelQueryException;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.MultiModelQueryRuntimeException;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.TableCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.emf.listener.RowDeleteCommand;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.emf.listener.TableInstanceListenerUtils;

public class RowDeleteCommandStackListener
implements CommandStackListener {
    protected static final String DEBUG_OPTION = "org.eclipse.emf.facet.widgets.table.ui/debug/RowDeleteCommandStackListener";
    protected static final boolean DEBUG = Activator.getDefault().isDebugging() && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.emf.facet.widgets.table.ui/debug/RowDeleteCommandStackListener"));
    private Table tableInstance;
    private EditingDomain editingDomain;
    private boolean enable = true;
    private ICommandFactory commandFactory;

    public RowDeleteCommandStackListener(Table tableInstance, EditingDomain editingDomain) {
        this.tableInstance = tableInstance;
        this.editingDomain = editingDomain;
        this.commandFactory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor(this.editingDomain);
    }

    public synchronized void commandStackChanged(EventObject event) {
        if (this.enable) {
            CommandStack commandStack;
            Command mostRecentCommand;
            DebugUtils.debug((boolean)DEBUG, (String)("(" + System.identityHashCode(event) + ")"));
            Object source = event.getSource();
            if (source instanceof CommandStack && !((mostRecentCommand = (commandStack = (CommandStack)source).getMostRecentCommand()) instanceof MostRecentAndDeleteCompoundCommand)) {
                try {
                    try {
                        Command mostRecentAndDeleteCompoundCommand = this.createMostRecentAndDeleteCompoundCommand(event, mostRecentCommand);
                        if (mostRecentAndDeleteCompoundCommand != null) {
                            this.enable = false;
                            DebugUtils.debug((boolean)DEBUG, (String)("(" + System.identityHashCode(event) + "): Exec undo"));
                            if (DEBUG) {
                                DebugUtils.debug((String)("(" + System.identityHashCode(event) + "): Exec redo+delete"));
                            }
                            this.editingDomain.getCommandStack().undo();
                            if (DEBUG) {
                                if (!mostRecentAndDeleteCompoundCommand.canExecute()) {
                                    DebugUtils.debug((String)("(" + System.identityHashCode(event) + "): Cannot execute redo+delete" + EmfDebugUtils.debugCommand((Command)mostRecentAndDeleteCompoundCommand) + '\n'));
                                    throw new CannotExecuteCommandException("Cannot execute redo+delete");
                                }
                                DebugUtils.debug((String)("(" + System.identityHashCode(event) + "): Exec redo+delete"));
                            }
                            this.editingDomain.getCommandStack().execute(mostRecentAndDeleteCompoundCommand);
                            if (this.editingDomain.getCommandStack().getMostRecentCommand() != mostRecentAndDeleteCompoundCommand) {
                                throw new CannotExecuteCommandException("Somethig was wrong in the redo+delete. Did you have installed/enabled the org.eclipse.emf.facet.widgets.table.metamodel.edit plugin ?");
                            }
                        }
                    }
                    catch (CannotExecuteCommandException e) {
                        throw e;
                    }
                    catch (MultiModelQueryException e) {
                        throw new MultiModelQueryRuntimeException(e);
                    }
                }
                finally {
                    this.enable = true;
                }
            }
        }
    }

    private Command createMostRecentAndDeleteCompoundCommand(EventObject event, Command triggeredCommand) throws MultiModelQueryException {
        MostRecentAndDeleteCompoundCommand result = null;
        if (triggeredCommand instanceof DeleteCommand) {
            DebugUtils.debug((boolean)DEBUG, (String)("(" + System.identityHashCode(event) + "): DeleteCommand found "));
            List<Row> toBeRemovedRows = TableInstanceListenerUtils.getRowsRepresentingADeletedEObject((List<Row>)this.tableInstance.getRows());
            if (!toBeRemovedRows.isEmpty()) {
                RowDeleteCommand removeRowCommand = new RowDeleteCommand(this.editingDomain, toBeRemovedRows);
                TableCommandFactory cmdFactory = new TableCommandFactory(this.tableInstance, this.editingDomain, (org.eclipse.emf.facet.util.emf.core.internal.exported.ICommandFactory)this.commandFactory);
                Command removeColumnCmd = cmdFactory.createRemoveUselessColumnsCommand(toBeRemovedRows, null);
                ArrayList<Command> commandList = new ArrayList<Command>();
                commandList.add(triggeredCommand);
                commandList.add((Command)removeRowCommand);
                if (removeColumnCmd != null) {
                    commandList.add(removeColumnCmd);
                }
                result = new MostRecentAndDeleteCompoundCommand(commandList);
                if (DEBUG) {
                    DebugUtils.debug((String)("(" + System.identityHashCode(event) + "): canExecute=" + result.canExecute()));
                }
            } else {
                ArrayList<Command> commandList = new ArrayList<Command>();
                commandList.add(triggeredCommand);
                result = new MostRecentAndDeleteCompoundCommand(commandList);
            }
        } else if (triggeredCommand instanceof CompoundCommand) {
            DebugUtils.debug((boolean)DEBUG, (String)("(" + System.identityHashCode(event) + "): CompoundCommand found (" + System.identityHashCode(triggeredCommand) + ")"));
            CompoundCommand compoundCommand = (CompoundCommand)triggeredCommand;
            MostRecentAndDeleteCompoundCommand resultCompoundCommand = new MostRecentAndDeleteCompoundCommand();
            for (Command command : compoundCommand.getCommandList()) {
                resultCompoundCommand.append(this.createMostRecentAndDeleteCompoundCommand(event, command));
            }
            if (!resultCompoundCommand.isEmpty()) {
                result = resultCompoundCommand;
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MostRecentAndDeleteCompoundCommand
    extends CompoundCommand {
        public MostRecentAndDeleteCompoundCommand() {
        }

        public MostRecentAndDeleteCompoundCommand(List<Command> commandList) {
            super(commandList);
        }
    }
}

