/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide;

import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ide.IDEWorkflow;
import org.eclipse.epp.internal.logging.aeri.ide.IIdeFactory;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventsQueue;
import org.eclipse.epp.internal.logging.aeri.ide.di.ExtensionPointReportProcessorsCreationFunction;
import org.eclipse.epp.internal.logging.aeri.ide.di.ImageRegistryCreationFunction;
import org.eclipse.epp.internal.logging.aeri.ide.di.LogListenerCreationFunction;
import org.eclipse.epp.internal.logging.aeri.ide.di.ReviewDialogCreationFunction;
import org.eclipse.epp.internal.logging.aeri.ide.di.SettingsPersistingRegistryServersCreationFunction;
import org.eclipse.epp.internal.logging.aeri.ide.di.SystemSettingsCreationFunction;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.ReviewDialog;
import org.eclipse.epp.internal.logging.aeri.ide.handlers.CreateConfigureDialogHandler;
import org.eclipse.epp.internal.logging.aeri.ide.handlers.OpenConfigureServersDialogHandler;
import org.eclipse.epp.internal.logging.aeri.ide.handlers.OpenReviewDialogHandler;
import org.eclipse.epp.internal.logging.aeri.ide.handlers.OpenServersSetupWizardHandler;
import org.eclipse.epp.internal.logging.aeri.ide.handlers.OpenSystemSetupWizardHandler;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.notifications.MylynNotificationsSupport;
import org.eclipse.epp.internal.logging.aeri.ide.utils.UploadReportsScheduler;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.SystemControl;
import org.eclipse.epp.logging.aeri.core.util.LogListener;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class IDEStartup
implements IStartup {
    public void earlyStartup() {
        if (Boolean.getBoolean("org.eclipse.epp.logging.aeri.skipReports")) {
            return;
        }
        new Job(Messages.JOB_NAME_INITIALIZING_AERI){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.TASK_NAME_INITIALIZING_AERI, -1);
                IEclipseContext aeriContext = IDEStartup.initializeIdeContext();
                IDEWorkflow cfr_ignored_0 = (IDEWorkflow)aeriContext.get(IDEWorkflow.class);
                LogListener listener = (LogListener)aeriContext.get(LogListener.class);
                Platform.addLogListener((ILogListener)listener);
                monitor.done();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private static IEclipseContext initializeIdeContext() {
        IEclipseContext context = SystemControl.getSystemContext();
        IEclipseContext parent = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        context.setParent(parent);
        context.set("org.eclipse.epp.logging.aeri.ide.di.review-in-progress", (Object)false);
        context.declareModifiable("org.eclipse.epp.logging.aeri.ide.di.review-in-progress");
        context.set("org.eclipse.epp.logging.aeri.ide.di.configure-in-progress", (Object)false);
        context.declareModifiable("org.eclipse.epp.logging.aeri.ide.di.configure-in-progress");
        context.set("org.eclipse.epp.logging.aeri.ide.di.notification-in-progress", (Object)false);
        context.declareModifiable("org.eclipse.epp.logging.aeri.ide.di.notification-in-progress");
        SystemControl.registerHandlers((Class[])new Class[]{OpenReviewDialogHandler.class, OpenServersSetupWizardHandler.class, OpenConfigureServersDialogHandler.class, OpenSystemSetupWizardHandler.class, CreateConfigureDialogHandler.class});
        context.set(ISystemSettings.class.getName(), (Object)new SystemSettingsCreationFunction());
        Bundle bundle = Platform.getBundle((String)"org.eclipse.epp.logging.aeri.ide");
        context.set(Bundle.class, (Object)bundle);
        context.set("org.eclipse.epp.logging.aeri.ide.stateLocation", (Object)Platform.getStateLocation((Bundle)bundle));
        context.set(ILogEventsQueue.class, (Object)IIdeFactory.eINSTANCE.createLogEventsQueue());
        context.set(LogListener.class.getName(), (Object)new LogListenerCreationFunction());
        LogListener listener = (LogListener)context.get(LogListener.class);
        Platform.addLogListener((ILogListener)listener);
        final IEventBroker broker = (IEventBroker)context.get(IEventBroker.class);
        context.set("org.eclipse.epp.logging.aeri.ide.servers", (Object)new SettingsPersistingRegistryServersCreationFunction());
        context.set("org.eclipse.epp.logging.aeri.ide.processors", (Object)new ExtensionPointReportProcessorsCreationFunction());
        context.set(MylynNotificationsSupport.class, (Object)((MylynNotificationsSupport)ContextInjectionFactory.make(MylynNotificationsSupport.class, (IEclipseContext)context)));
        context.set(UploadReportsScheduler.class, (Object)new UploadReportsScheduler(){

            @Override
            public void send(ILogEventGroup group, IProgressMonitor monitor) {
                super.send(group, monitor);
                broker.post("org/eclipse/epp/internal/logging/aeri/ui/events/responses", (Object)group);
            }
        });
        context.set(IDEWorkflow.class, (Object)((IDEWorkflow)ContextInjectionFactory.make(IDEWorkflow.class, (IEclipseContext)context)));
        IDEWorkflow cfr_ignored_0 = (IDEWorkflow)context.get(IDEWorkflow.class);
        context.set(ImageRegistry.class.getName(), (Object)new ImageRegistryCreationFunction());
        context.set(ReviewDialog.class.getName(), (Object)new ReviewDialogCreationFunction());
        context.declareModifiable("org.eclipse.epp.logging.aeri.ide.di.event.last");
        context.declareModifiable("org.eclipse.epp.logging.aeri.ide.di.event.last-delayed");
        context.declareModifiable("org.eclipse.epp.logging.aeri.ide.di.event.last-notified");
        return context;
    }
}

