/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.core.internal.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.gmt.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.gmt.modisco.infra.common.core.internal.protocol.IModiscoProtocolExtension;
import org.eclipse.gmt.modisco.infra.common.core.internal.protocol.ModiscoProtocolException;
import org.eclipse.gmt.modisco.infra.common.core.internal.protocol.ModiscoProtocolExtensionRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModiscoURIHandler
implements URIHandler {
    private static final String DEBUG_ID = "org.eclipse.gmt.modisco.infra.common.core/debug/ModiscoURIHandler/debug";
    public static final boolean DEBUG = CommonModiscoActivator.getDefault().isDebugging() && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.gmt.modisco.infra.common.core/debug/ModiscoURIHandler/debug"));

    public boolean canHandle(URI uri) {
        return uri != null && "modisco".equals(uri.scheme());
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        URI convertedURI = this.convertURI(uri);
        for (URIHandler defaultUriHandler : URIHandler.DEFAULT_HANDLERS) {
            if (!defaultUriHandler.canHandle(convertedURI)) continue;
            return defaultUriHandler.contentDescription(convertedURI, options);
        }
        return null;
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        URI convertedURI = this.convertURI(uri);
        for (URIHandler defaultUriHandler : URIHandler.DEFAULT_HANDLERS) {
            if (!defaultUriHandler.canHandle(convertedURI)) continue;
            return defaultUriHandler.createInputStream(convertedURI, options);
        }
        return null;
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        URI convertedURI = this.convertURI(uri);
        for (URIHandler defaultUriHandler : URIHandler.DEFAULT_HANDLERS) {
            if (!defaultUriHandler.canHandle(convertedURI)) continue;
            return defaultUriHandler.createOutputStream(convertedURI, options);
        }
        return null;
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        URI convertedURI = this.convertURI(uri);
        for (URIHandler defaultUriHandler : URIHandler.DEFAULT_HANDLERS) {
            if (!defaultUriHandler.canHandle(convertedURI)) continue;
            defaultUriHandler.delete(convertedURI, options);
            break;
        }
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        try {
            URI convertedURI = this.convertURI(uri);
            for (URIHandler defaultUriHandler : URIHandler.DEFAULT_HANDLERS) {
                if (!defaultUriHandler.canHandle(convertedURI)) continue;
                return defaultUriHandler.exists(convertedURI, options);
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return false;
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        try {
            URI convertedURI = this.convertURI(uri);
            for (URIHandler defaultUriHandler : URIHandler.DEFAULT_HANDLERS) {
                if (!defaultUriHandler.canHandle(convertedURI)) continue;
                return defaultUriHandler.getAttributes(convertedURI, options);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return null;
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        URI convertedURI = this.convertURI(uri);
        for (URIHandler defaultUriHandler : URIHandler.DEFAULT_HANDLERS) {
            if (!defaultUriHandler.canHandle(convertedURI)) continue;
            defaultUriHandler.setAttributes(convertedURI, attributes, options);
            break;
        }
    }

    private URI convertURI(URI uri) throws IOException {
        URI convertedURI;
        try {
            String schemeSpecificPart = uri.segment(0);
            IModiscoProtocolExtension factoryExt = ModiscoProtocolExtensionRegistry.getFactoryExtMap().get(schemeSpecificPart);
            if (factoryExt == null) {
                ModiscoProtocolException e = new ModiscoProtocolException("Wrong sub modisco protocol: " + schemeSpecificPart);
                throw e;
            }
            convertedURI = factoryExt.getURI(uri.segment(1));
            if (convertedURI == null) {
                ModiscoProtocolException e = new ModiscoProtocolException("Model not found: " + schemeSpecificPart + ": " + uri.segment(1));
                throw e;
            }
        }
        catch (IOException e) {
            if (DEBUG) {
                Status status = new Status(4, "org.eclipse.gmt.modisco.infra.common.core", e.getMessage(), (Throwable)e);
                CommonModiscoActivator.getDefault().getLog().log((IStatus)status);
            }
            throw e;
        }
        return convertedURI;
    }
}

