/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.chess.features;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.examples.chess.MoveUtil;
import org.eclipse.graphiti.examples.chess.diagram.ChessFeatureProvider;
import org.eclipse.graphiti.examples.mm.chess.Colors;
import org.eclipse.graphiti.examples.mm.chess.Piece;
import org.eclipse.graphiti.examples.mm.chess.Square;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IMultiDeleteInfo;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.features.context.impl.MultiDeleteInfo;
import org.eclipse.graphiti.features.impl.DefaultMoveShapeFeature;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.util.IColorConstant;

public class MoveChessPieceFeature
extends DefaultMoveShapeFeature {
    public MoveChessPieceFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canMoveShape(IMoveShapeContext context) {
        Square targetSquare;
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)context.getShape());
        if (!(bo instanceof Piece)) {
            return false;
        }
        Piece piece = (Piece)bo;
        if (context.getSourceContainer().equals(context.getTargetContainer())) {
            return false;
        }
        Square sourceSquare = (Square)this.getBusinessObjectForPictogramElement((PictogramElement)context.getSourceContainer());
        Object targetBO = this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
        if (targetBO instanceof Square) {
            targetSquare = (Square)targetBO;
        } else if (targetBO instanceof Piece) {
            targetSquare = ((Piece)targetBO).getSquare();
        } else {
            return false;
        }
        return MoveUtil.isMoveAllowed(piece, sourceSquare, targetSquare);
    }

    protected void preMoveShape(IMoveShapeContext context) {
        MoveShapeContext moveContext = (MoveShapeContext)context;
        moveContext.setX(0);
        moveContext.setY(0);
        Object targetContainerBO = this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
        if (targetContainerBO instanceof Piece) {
            moveContext.setTargetContainer(context.getTargetContainer().getContainer());
        }
    }

    protected void postMoveShape(IMoveShapeContext context) {
        Piece piece = (Piece)this.getBusinessObjectForPictogramElement((PictogramElement)context.getShape());
        Square targetSquare = (Square)this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
        if (targetSquare.getPiece() != null) {
            this.deleteTakenPieceFromSquare(targetSquare);
        }
        piece.setSquare(targetSquare);
        this.adaptMovedPieceShape(context, targetSquare);
    }

    private void adaptMovedPieceShape(IMoveShapeContext context, Square targetSquare) {
        Polygon polygon = (Polygon)context.getShape().getGraphicsAlgorithm();
        if (Colors.LIGHT.equals((Object)targetSquare.getColor())) {
            polygon.setForeground(this.manageColor(IColorConstant.BLACK));
        } else {
            polygon.setForeground(this.manageColor(IColorConstant.WHITE));
        }
        polygon.setLineWidth(Integer.valueOf(2));
    }

    private void deleteTakenPieceFromSquare(Square targetSquare) {
        ContainerShape takenPieceShape = (ContainerShape)Graphiti.getLinkService().getPictogramElements(this.getDiagram(), (EObject)targetSquare.getPiece()).get(0);
        DeleteContext deleteContext = new DeleteContext((PictogramElement)takenPieceShape);
        MultiDeleteInfo multiDeleteInfo = new MultiDeleteInfo(false, false, 0);
        deleteContext.setMultiDeleteInfo((IMultiDeleteInfo)multiDeleteInfo);
        try {
            ((ChessFeatureProvider)this.getFeatureProvider()).setProgrammaticFeatureCallActive(true);
            IDeleteFeature deleteFeature = this.getFeatureProvider().getDeleteFeature((IDeleteContext)deleteContext);
            deleteFeature.execute((IContext)deleteContext);
        }
        finally {
            ((ChessFeatureProvider)this.getFeatureProvider()).setProgrammaticFeatureCallActive(false);
        }
    }
}

