/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryProviderInstallOperationConfig;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.common.facet.libraryprovider.jsf.JsfLibraryUtil;
import org.eclipse.jst.jsf.common.webxml.WebXmlUpdater;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFFacetException;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtilFactory;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils;
import org.eclipse.jst.jsf.core.internal.project.facet.JsfFacetConfigurationUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class JSFFacetInstallDelegate
implements IDelegate {
    private final boolean jsfFacetConfigurationEnabled = JsfFacetConfigurationUtil.isJsfFacetConfigurationEnabled();

    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IDataModel config = null;
            if (cfg == null) {
                throw new JSFFacetException(Messages.JSFFacetInstallDelegate_InternalErr);
            }
            config = (IDataModel)cfg;
            JSFUtils jsfUtil = new JSFUtilFactory().create(fv, ModelProviderManager.getModelProvider((IProject)project));
            if (jsfUtil == null) {
                throw new JSFFacetException(NLS.bind((String)Messages.Could_Not_GetJSFVersion, (Object)fv.toString()));
            }
            if (this.jsfFacetConfigurationEnabled) {
                IModelProvider provider = jsfUtil.getModelProvider();
                if (provider == null) {
                    throw new JSFFacetException(NLS.bind((String)Messages.JSFFacetInstallDelegate_ConfigErr, (Object)project.getName()));
                }
                if (!provider.validateEdit(null, null).isOK() && !provider.validateEdit(null, null).isOK()) {
                    throw new JSFFacetException(NLS.bind((String)Messages.JSFFacetInstallDelegate_NonUpdateableWebXML, (Object)project.getName()));
                }
            }
            ((LibraryInstallDelegate)config.getProperty("IJSFFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE")).execute((IProgressMonitor)new NullProgressMonitor());
            LibraryInstallDelegate libDelegate = (LibraryInstallDelegate)config.getProperty("IJSFFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE");
            LibraryProviderOperationConfig libConfig = libDelegate.getLibraryProviderOperationConfig();
            if (this.jsfFacetConfigurationEnabled) {
                this.createConfigFile(project, fv, config, monitor, jsfUtil);
                Boolean configureServlet = (Boolean)config.getProperty("IJSFFacetInstallDataModelProperties.CONFIGURE_SERVLET");
                if (configureServlet == null || configureServlet.booleanValue()) {
                    this.createServletAndModifyWebXML(project, config, monitor, jsfUtil);
                    this.updateWebXmlByJsfVendor(libConfig, project, monitor);
                }
            }
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void updateWebXmlByJsfVendor(LibraryProviderOperationConfig libConfig, IProject project, IProgressMonitor monitor) {
        UserLibraryProviderInstallOperationConfig userLibConfig = JSFFacetInstallDelegate.getUserLibConfig(libConfig);
        if (userLibConfig == null) {
            return;
        }
        switch (JsfLibraryUtil.getJsfLibraryVendorType((UserLibraryProviderInstallOperationConfig)userLibConfig)) {
            case MYFACES: {
                JSFFacetInstallDelegate.updateWebXmlForMyfaces(project, monitor);
                break;
            }
            case SUN_RI: {
                JSFFacetInstallDelegate.updateWebXmlForSunRi(project, monitor);
                break;
            }
        }
    }

    public static UserLibraryProviderInstallOperationConfig getUserLibConfig(LibraryProviderOperationConfig libConfig) {
        if (!(libConfig instanceof UserLibraryProviderInstallOperationConfig)) {
            return null;
        }
        return (UserLibraryProviderInstallOperationConfig)libConfig;
    }

    public static void updateWebXmlForMyfaces(IProject project, IProgressMonitor monitor) {
        WebXmlUpdater updater = new WebXmlUpdater(project, monitor);
        updater.addContextParam("javax.servlet.jsp.jstl.fmt.localizationContext", "resources.application", null);
        updater.addContextParam("javax.faces.STATE_SAVING_METHOD", "client", Messages.JSFFacetInstallDelegate_StateSavingMethod);
        updater.addContextParam("org.apache.myfaces.ALLOW_JAVASCRIPT", "true", Messages.JSFFacetInstallDelegate_AllowJavascriptDescription);
        updater.addContextParam("org.apache.myfaces.PRETTY_HTML", "true", Messages.JSFFacetInstallDelegate_PrettyHtmlDescription);
        updater.addContextParam("org.apache.myfaces.DETECT_JAVASCRIPT", "false", null);
        updater.addContextParam("org.apache.myfaces.AUTO_SCROLL", "true", Messages.JSFFacetInstallDelegate_AutoScrollDescription);
        updater.addListener("org.apache.myfaces.webapp.StartupServletContextListener");
    }

    public static void updateWebXmlForSunRi(IProject project, IProgressMonitor monitor) {
        WebXmlUpdater updater = new WebXmlUpdater(project, monitor);
        updater.addContextParam("javax.faces.STATE_SAVING_METHOD", "client", Messages.JSFFacetInstallDelegate_StateSavingMethod);
        updater.addContextParam("javax.servlet.jsp.jstl.fmt.localizationContext", "resources.application", null);
        updater.addListener("com.sun.faces.config.ConfigureListener");
    }

    private IPath resolveConfigPath(IProject project, String jsfConfigPath, JSFUtils jsfUtils) {
        IPath path = null;
        IPath webXMLPath = this.getWebXMLPathFromModel(jsfUtils);
        if (webXMLPath != null) {
            path = webXMLPath.removeLastSegments(2).append(jsfConfigPath);
        }
        if (path == null) {
            path = ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder().getRawLocation().append((IPath)new Path(jsfConfigPath));
        }
        return path;
    }

    private void createConfigFile(final IProject project, IProjectFacetVersion fv, IDataModel config, IProgressMonitor monitor, final JSFUtils jsfUtil) {
        final IPath configPath = this.resolveConfigPath(project, config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH"), jsfUtil);
        try {
            if (!configPath.toFile().exists()) {
                IWorkspaceRunnable op = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor_inner) throws CoreException {
                        jsfUtil.createConfigFile(configPath);
                        project.refreshLocal(2, monitor_inner);
                    }
                };
                op.run(monitor);
            }
        }
        catch (CoreException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Exception occured while creating faces-config.xml");
        }
    }

    private void createServletAndModifyWebXML(IProject project, IDataModel config, IProgressMonitor monitor, JSFUtils jsfUtil) {
        if (this.shouldModify(jsfUtil)) {
            IModelProvider provider = jsfUtil.getModelProvider();
            IPath webXMLPath = new Path("WEB-INF").append("web.xml");
            if (jsfUtil.isJavaEE(provider.getModelObject())) {
                provider.modify((Runnable)new UpdateWebXMLForJavaEE(project, config, jsfUtil), this.doesDDFileExist(jsfUtil) ? webXMLPath : IModelProvider.FORCESAVE);
            } else {
                provider.modify((Runnable)new UpdateWebXMLForJ2EE(project, config, jsfUtil), webXMLPath);
            }
        }
    }

    private boolean shouldModify(JSFUtils jsfUtil) {
        Object objServlet;
        Object objWebApp;
        boolean shouldModify = true;
        IModelProvider provider = jsfUtil.getModelProvider();
        if (provider != null && (objWebApp = provider.getModelObject()) != null && (objServlet = jsfUtil.findJSFServlet(objWebApp)) != null) {
            shouldModify = false;
        }
        return shouldModify;
    }

    private boolean doesDDFileExist(JSFUtils jsfUtils) {
        boolean exists = false;
        IPath path = this.getWebXMLPathFromModel(jsfUtils);
        if (path != null) {
            exists = path.toFile().exists();
        }
        return exists;
    }

    private IPath getWebXMLPathFromModel(JSFUtils jsfUtils) {
        IResource iResource;
        IWorkspaceRoot root;
        IWorkspace workspace;
        URI uri;
        Resource resource;
        Object modelObject;
        IModelProvider provider;
        IPath path = null;
        if (jsfUtils != null && (provider = jsfUtils.getModelProvider()) != null && (modelObject = provider.getModelObject()) instanceof EObject && (resource = ((EObject)modelObject).eResource()) != null && (uri = resource.getURI()) != null && uri.isPlatformResource() && (workspace = ResourcesPlugin.getWorkspace()) != null && (root = workspace.getRoot()) != null && (iResource = root.findMember((IPath)new Path(uri.toPlatformString(true)))) != null) {
            path = iResource.getLocation();
        }
        return path;
    }

    private class UpdateWebXMLForJ2EE
    implements Runnable {
        private final IProject project;
        private final IDataModel config;
        private final JSFUtils jsfUtil;

        UpdateWebXMLForJ2EE(IProject project, IDataModel config, JSFUtils jsfUtil) {
            this.project = project;
            this.config = config;
            this.jsfUtil = jsfUtil;
        }

        public void run() {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)ModelProviderManager.getModelProvider((IProject)this.project).getModelObject();
            this.jsfUtil.updateWebApp(webApp, this.config);
        }
    }

    private class UpdateWebXMLForJavaEE
    implements Runnable {
        private final IProject project;
        private final IDataModel config;
        private final JSFUtils jsfUtil;

        UpdateWebXMLForJavaEE(IProject project, IDataModel config, JSFUtils jsfUtil) {
            this.project = project;
            this.config = config;
            this.jsfUtil = jsfUtil;
        }

        public void run() {
            WebApp webApp = (WebApp)ModelProviderManager.getModelProvider((IProject)this.project).getModelObject();
            this.jsfUtil.updateWebApp(webApp, this.config);
        }
    }
}

