/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.proposals;

import java.security.InvalidParameterException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.ManpageCacher;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetItemType;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public abstract class STPCompletionProposal
implements ICompletionProposal {
    private final int fPrefixLength;
    private final int fReplacementOffset;
    private final String fDisplayString;
    protected final TreeNode fCompletionNode;
    protected String fDocumentation = null;

    public STPCompletionProposal(TreeNode completionNode, int prefixLength, int replacementOffset) {
        if (completionNode == null) {
            throw new InvalidParameterException();
        }
        this.fCompletionNode = completionNode;
        this.fPrefixLength = prefixLength;
        this.fReplacementOffset = replacementOffset;
        this.fDisplayString = String.valueOf(completionNode.toString()) + " - " + this.getType().toString();
    }

    protected String getReplacementString() {
        return this.fCompletionNode.toString();
    }

    protected int getCursorPosition() {
        return this.getReplacementString().length() - this.fPrefixLength;
    }

    public String getAdditionalProposalInfo() {
        if (this.fDocumentation == null) {
            this.fDocumentation = ManpageCacher.getDocumentation(this.getType(), this.getDocumentationSearchArgs());
        }
        return this.fDocumentation;
    }

    protected abstract TapsetItemType getType();

    protected String[] getDocumentationSearchArgs() {
        return new String[]{this.fCompletionNode.toString()};
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.fReplacementOffset, 0, this.getReplacementString().substring(this.fPrefixLength));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.getCursorPosition(), 0);
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

