/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.color;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.color.ColorInformationMining;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.DocumentColorParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Display;

public class DocumentColorProvider
extends AbstractCodeMiningProvider {
    private final Map<RGBA, Color> colorTable = new HashMap<RGBA, Color>();

    private CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(@NonNull IDocument document) {
        return CompletableFuture.supplyAsync(() -> {
            List<@NonNull LanguageServiceAccessor.LSPDocumentInfo> docInfos = LanguageServiceAccessor.getLSPDocumentInfosFor(document, capabilities -> capabilities.getColorProvider() != null && (capabilities.getColorProvider().getLeft() != null && (Boolean)capabilities.getColorProvider().getLeft() != false || capabilities.getColorProvider().getRight() != null));
            CompletableFuture[] requests = new CompletableFuture[docInfos.size()];
            List colorResults = Collections.synchronizedList(new ArrayList(docInfos.size()));
            int i = 0;
            while (i < docInfos.size()) {
                LanguageServiceAccessor.LSPDocumentInfo info = docInfos.get(i);
                ServerCapabilities capabilites = info.getCapabilites();
                TextDocumentIdentifier textDocumentIdentifier = new TextDocumentIdentifier(info.getFileUri().toString());
                DocumentColorParams param = new DocumentColorParams(textDocumentIdentifier);
                requests[i] = ((CompletableFuture)info.getInitializedLanguageClient().thenCompose(languageServer -> languageServer.getTextDocumentService().documentColor(param))).thenAccept(colors -> {
                    for (ColorInformation color : colors) {
                        if (color == null || capabilites == null) continue;
                        try {
                            colorResults.add(new ColorInformationMining(color, document, textDocumentIdentifier, info.getInitializedLanguageClient(), this));
                        }
                        catch (BadLocationException e) {
                            LanguageServerPlugin.logError(e);
                        }
                    }
                });
                ++i;
            }
            CompletableFuture.allOf(requests).join();
            return colorResults;
        });
    }

    public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        return this.provideCodeMinings(viewer.getDocument());
    }

    public Color getColor(RGBA rgba, Display display) {
        Color color = this.colorTable.get(rgba);
        if (color == null) {
            color = new Color((Device)display, rgba);
            this.colorTable.put(rgba, color);
        }
        return color;
    }

    public void dispose() {
        this.colorTable.values().forEach(color -> color.dispose());
        super.dispose();
    }
}

