/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.refactoring.internal;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.m2e.refactoring.internal.Activator;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefactoringImages {
    private static final Logger log = LoggerFactory.getLogger(RefactoringImages.class);
    public static final ImageDescriptor EXCLUDE = RefactoringImages.create("exclude.gif");

    private static ImageDescriptor create(String key) {
        try {
            ImageDescriptor imageDescriptor = RefactoringImages.createDescriptor(key);
            ImageRegistry imageRegistry = RefactoringImages.getImageRegistry();
            if (imageRegistry != null) {
                imageRegistry.put(key, imageDescriptor);
            }
            return imageDescriptor;
        }
        catch (Exception ex) {
            log.error(key, (Throwable)ex);
            return null;
        }
    }

    private static ImageRegistry getImageRegistry() {
        Activator plugin = Activator.getDefault();
        return plugin == null ? null : plugin.getImageRegistry();
    }

    private static ImageDescriptor createDescriptor(String image) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.m2e.refactoring", (String)("icons/" + image));
    }
}

