/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.architecture.editor;

import java.util.Arrays;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.provider.ArchitectureEditPlugin;
import org.eclipse.papyrus.infra.ui.architecture.ArchitectureUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ExtendedLoadResourceAction
extends LoadResourceAction {
    public void run() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        new ExtendedLoadResourceDialog(shell, this.domain).open();
    }

    public static class ExtendedLoadResourceDialog
    extends LoadResourceAction.LoadResourceDialog {
        public ExtendedLoadResourceDialog(Shell parent, EditingDomain domain) {
            super(parent, domain);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite buttonComposite = (Composite)composite.getChildren()[0];
            Button browseRegisteredArchitectureButton = new Button(buttonComposite, 8);
            browseRegisteredArchitectureButton.setText(ArchitectureUIPlugin.INSTANCE.getString("_UI_BrowseRegisteredArchitectures_label"));
            this.prepareBrowseRegisteredArchitecturesButton(browseRegisteredArchitectureButton);
            FormData data = new FormData();
            Control[] children = buttonComposite.getChildren();
            data.right = new FormAttachment(children[0], -10);
            browseRegisteredArchitectureButton.setLayoutData((Object)data);
            return composite;
        }

        protected void prepareBrowseRegisteredArchitecturesButton(Button browseRegisteredArchitecturesButton) {
            browseRegisteredArchitecturesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    RegisteredArchitectureDialog registeredArchitectureDialog = new RegisteredArchitectureDialog(this.getShell());
                    registeredArchitectureDialog.open();
                    Object[] results = registeredArchitectureDialog.getResult();
                    if (results != null) {
                        StringBuffer uris = new StringBuffer();
                        Object[] objectArray = results;
                        if (results.length != 0) {
                            Object result = objectArray[0];
                            uris.append(result.toString());
                            uris.append("  ");
                        }
                        uriField.setText((String.valueOf(uriField.getText()) + "  " + uris.toString()).trim());
                    }
                }
            });
        }
    }

    public static class RegisteredArchitectureDialog
    extends ElementListSelectionDialog {
        public RegisteredArchitectureDialog(Shell parent) {
            super(parent, (ILabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    return ExtendedImageRegistry.getInstance().getImage(ArchitectureEditPlugin.INSTANCE.getImage("full/obj16/ArchitectureDomain"));
                }
            });
            this.setMultipleSelection(true);
            this.setMessage(ArchitectureUIPlugin.INSTANCE.getString("_UI_SelectRegisteredArchitecture"));
            this.setFilter("*");
            this.setTitle(ArchitectureUIPlugin.INSTANCE.getString("_UI_ArchitectureSelection_label"));
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            Object[] architectures = ArchitectureDomainManager.getInstance().getRegisteredArchitectureModels().toArray(new Object[0]);
            Arrays.sort(architectures);
            this.setListElements(architectures);
            return result;
        }
    }
}

