/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.model.IEnableDisableTarget;
import org.eclipse.ptp.debug.core.model.IPAddressBreakpoint;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.debug.core.model.IPDebugElement;
import org.eclipse.ptp.debug.core.model.IPDebugElementStatus;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.model.IPDummyStackFrame;
import org.eclipse.ptp.debug.core.model.IPFunctionBreakpoint;
import org.eclipse.ptp.debug.core.model.IPGlobalVariable;
import org.eclipse.ptp.debug.core.model.IPLineBreakpoint;
import org.eclipse.ptp.debug.core.model.IPModule;
import org.eclipse.ptp.debug.core.model.IPSignal;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.IPThread;
import org.eclipse.ptp.debug.core.model.IPValue;
import org.eclipse.ptp.debug.core.model.IPVariable;
import org.eclipse.ptp.debug.core.model.IPWatchpoint;
import org.eclipse.ptp.debug.core.model.PDebugElementState;
import org.eclipse.ptp.debug.core.pdi.event.IPDIBreakpointInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIExitInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDISharedLibraryInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDISignalInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIWatchpointScopeInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIWatchpointTriggerInfo;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFType;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeAggregate;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeChar;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypePointer;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeRange;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeReference;
import org.eclipse.ptp.internal.debug.core.sourcelookup.PSourceNotFoundElement;
import org.eclipse.ptp.internal.debug.ui.OverlayImageCache;
import org.eclipse.ptp.internal.debug.ui.OverlayImageDescriptor;
import org.eclipse.ptp.internal.debug.ui.PAnnotationManager;
import org.eclipse.ptp.internal.debug.ui.PDebugImage;
import org.eclipse.ptp.internal.debug.ui.PDebugUIUtils;
import org.eclipse.ptp.internal.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.internal.debug.ui.PValueDetailProvider;
import org.eclipse.ptp.internal.debug.ui.UIDebugManager;
import org.eclipse.ptp.internal.debug.ui.messages.Messages;
import org.eclipse.ptp.internal.ui.model.IElementHandler;
import org.eclipse.ptp.internal.ui.model.IElementSet;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation,
IDebugEditorPresentation {
    private static PDebugModelPresentation instance = null;
    public static final String DISPLAY_FULL_PATHS = "DISPLAY_FULL_PATHS";
    private static final String DUMMY_STACKFRAME_LABEL = "...";
    protected Map<String, Object> attributes = new HashMap<String, Object>(3);
    private final OverlayImageCache imageCache = new OverlayImageCache();
    protected UIDebugManager uiDebugManager = null;

    public static PDebugModelPresentation getDefault() {
        if (instance == null) {
            instance = new PDebugModelPresentation();
        }
        return instance;
    }

    public PDebugModelPresentation() {
        if (instance == null) {
            instance = this;
        }
    }

    public boolean addAnnotations(IEditorPart editorPart, IStackFrame frame) {
        try {
            if (frame instanceof IPStackFrame) {
                PAnnotationManager.getDefault().addAnnotation(editorPart, (IPStackFrame)frame);
                return true;
            }
        }
        catch (CoreException e) {
            return false;
        }
        return false;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        PValueDetailProvider.getDefault().computeDetail(value, listener);
    }

    public void dispose() {
        this.getImageCache().disposeAll();
        this.attributes.clear();
        super.dispose();
    }

    public String getEditorId(IEditorInput input, Object element) {
        return PDebugUIUtils.getEditorId(input, element);
    }

    public IEditorInput getEditorInput(Object element) {
        return PDebugUIUtils.getEditorInput(element);
    }

    public Image getImage(Object element) {
        Image baseImage = this.getBaseImage(element);
        if (baseImage != null) {
            ImageDescriptor[] overlays = new ImageDescriptor[4];
            if (element instanceof IPDebugElementStatus && !((IPDebugElementStatus)element).isOK()) {
                switch (((IPDebugElementStatus)element).getSeverity()) {
                    case 1: {
                        overlays[2] = PDebugImage.getDescriptor("no.gif");
                        break;
                    }
                    case 2: {
                        overlays[2] = PDebugImage.getDescriptor("no.gif");
                    }
                }
            }
            if (element instanceof IWatchExpression && ((IWatchExpression)element).hasErrors()) {
                overlays[2] = PDebugImage.getDescriptor("no.gif");
            }
            if (element instanceof IPVariable && ((IPVariable)element).isArgument()) {
                overlays[1] = PDebugImage.getDescriptor("no.gif");
            }
            if (element instanceof IPGlobalVariable && !(element instanceof IRegister)) {
                overlays[1] = PDebugImage.getDescriptor("no.gif");
            }
            return this.getImageCache().getImageFor(new OverlayImageDescriptor(baseImage, overlays));
        }
        return null;
    }

    public String getText(Object element) {
        IEnableDisableTarget target;
        String bt = this.getBaseText(element);
        if (bt == null) {
            return null;
        }
        StringBuffer baseText = new StringBuffer(bt);
        if (element instanceof IPDebugElementStatus && !((IPDebugElementStatus)element).isOK()) {
            baseText.append(NLS.bind((String)" <{0}>", (Object[])new Object[]{((IPDebugElementStatus)element).getMessage()}));
        }
        if (element instanceof IAdaptable && (target = (IEnableDisableTarget)((IAdaptable)element).getAdapter(IEnableDisableTarget.class)) != null && !target.isEnabled()) {
            baseText.append(' ');
            baseText.append(Messages.PDebugModelPresentation_0);
        }
        return baseText.toString();
    }

    public void removeAnnotations(IEditorPart editorPart, IThread thread) {
    }

    public void setAttribute(String attribute, Object value) {
        if (value == null) {
            return;
        }
        this.getAttributes().put(attribute, value);
    }

    private ImageDescriptor[] computeBreakpointOverlays(IPBreakpoint breakpoint) {
        ImageDescriptor[] overlays = new ImageDescriptor[4];
        try {
            if (breakpoint.isGlobal()) {
                ImageDescriptor imageDescriptor = overlays[0] = breakpoint.isEnabled() ? PDebugImage.getDescriptor("global_ovr.gif") : PDebugImage.getDescriptor("global_ovr_disabled.gif");
            }
            if (breakpoint.isConditional()) {
                ImageDescriptor imageDescriptor = overlays[2] = breakpoint.isEnabled() ? PDebugImage.getDescriptor("conditional_ovr.gif") : PDebugImage.getDescriptor("conditional_ovr_disabled.gif");
            }
            if (breakpoint.isInstalled()) {
                ImageDescriptor imageDescriptor = overlays[2] = breakpoint.isEnabled() ? PDebugImage.getDescriptor("installed_ovr.gif") : PDebugImage.getDescriptor("installed_ovr_disabled.gif");
            }
            if (breakpoint instanceof IPAddressBreakpoint) {
                ImageDescriptor imageDescriptor = overlays[1] = breakpoint.isEnabled() ? PDebugImage.getDescriptor("address_ovr.gif") : PDebugImage.getDescriptor("address_ovr_disabled.gif");
            }
            if (breakpoint instanceof IPFunctionBreakpoint) {
                overlays[3] = breakpoint.isEnabled() ? PDebugImage.getDescriptor("function_ovr.gif") : PDebugImage.getDescriptor("function_ovr_disabled.gif");
            }
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
        return overlays;
    }

    private Map<String, Object> getAttributes() {
        return this.attributes;
    }

    private Image getBaseImage(Object element) {
        IBreakpoint bp;
        if (element instanceof IPDebugTarget) {
            IPDebugTarget target = (IPDebugTarget)element;
            if (target.isPostMortem()) {
                return DebugUITools.getImage((String)"IMG_OBJS_DEBUG_TARGET_TERMINATED");
            }
            if (target.isTerminated() || target.isDisconnected()) {
                return DebugUITools.getImage((String)"IMG_OBJS_DEBUG_TARGET_TERMINATED");
            }
            return DebugUITools.getImage((String)"IMG_OBJS_DEBUG_TARGET");
        }
        if (element instanceof IPThread) {
            IPThread thread = (IPThread)element;
            IPDebugTarget target = thread.getDebugTarget();
            if (target.isPostMortem()) {
                return DebugUITools.getImage((String)"IMG_OBJS_THREAD_TERMINATED");
            }
            if (thread.isSuspended()) {
                return DebugUITools.getImage((String)"IMG_OBJS_THREAD_SUSPENDED");
            }
            if (thread.isTerminated()) {
                return DebugUITools.getImage((String)"IMG_OBJS_THREAD_TERMINATED");
            }
            return DebugUITools.getImage((String)"IMG_OBJS_THREAD_RUNNING");
        }
        if (element instanceof IMarker && (bp = this.getBreakpoint((IMarker)element)) != null && bp instanceof IPBreakpoint) {
            return this.getBreakpointImage((IPBreakpoint)bp);
        }
        if (element instanceof IPBreakpoint) {
            return this.getBreakpointImage((IPBreakpoint)element);
        }
        if (element instanceof IRegisterGroup) {
            return this.getRegisterGroupImage((IRegisterGroup)element);
        }
        if (element instanceof IExpression) {
            return this.getExpressionImage((IExpression)element);
        }
        if (element instanceof IRegister) {
            return this.getRegisterImage((IRegister)element);
        }
        if (element instanceof IVariable) {
            return this.getVariableImage((IVariable)element);
        }
        if (element instanceof IPModule) {
            return this.getModuleImage((IPModule)element);
        }
        if (element instanceof IPSignal) {
            return this.getSignalImage((IPSignal)element);
        }
        return super.getImage(element);
    }

    private String getBaseText(Object element) {
        StringBuffer label;
        boolean showQualified;
        block21: {
            showQualified = this.isShowQualifiedNames();
            label = new StringBuffer();
            if (element instanceof IPModule) {
                label.append(this.getModuleText((IPModule)element, showQualified));
                return label.toString();
            }
            if (element instanceof IPSignal) {
                label.append(this.getSignalText((IPSignal)element));
                return label.toString();
            }
            if (element instanceof IRegisterGroup) {
                label.append(((IRegisterGroup)element).getName());
                return label.toString();
            }
            if (element instanceof IWatchExpression) {
                return this.getWatchExpressionText((IWatchExpression)element);
            }
            if (element instanceof IVariable) {
                label.append(this.getVariableText((IVariable)element));
                return label.toString();
            }
            if (element instanceof IValue) {
                label.append(this.getValueText((IValue)element));
                return label.toString();
            }
            if (element instanceof IStackFrame) {
                label.append(this.getStackFrameText((IStackFrame)element, showQualified));
                return label.toString();
            }
            if (element instanceof PSourceNotFoundElement) {
                return this.getBaseText(((PSourceNotFoundElement)element).getElement());
            }
            if (!(element instanceof IMarker)) break block21;
            IBreakpoint breakpoint = this.getBreakpoint((IMarker)element);
            if (breakpoint != null) {
                return this.getBreakpointText(breakpoint, showQualified);
            }
            return null;
        }
        try {
            if (element instanceof IBreakpoint) {
                return this.getBreakpointText((IBreakpoint)element, showQualified);
            }
            if (element instanceof IDebugTarget) {
                label.append(this.getTargetText((IDebugTarget)element, showQualified));
            } else if (element instanceof IThread) {
                label.append(this.getThreadText((IThread)element, showQualified));
            }
            if (label.length() > 0) {
                return label.toString();
            }
            if (element instanceof ITerminate && ((ITerminate)element).isTerminated()) {
                label.insert(0, Messages.PDebugModelPresentation_1);
                return label.toString();
            }
            if (element instanceof IDisconnect && ((IDisconnect)element).isDisconnected()) {
                label.insert(0, Messages.PDebugModelPresentation_2);
                return label.toString();
            }
            if (label.length() > 0) {
                return label.toString();
            }
        }
        catch (DebugException e) {
            return NLS.bind((String)Messages.PDebugModelPresentation_3, (Object[])new Object[]{e.getMessage()});
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
        return null;
    }

    private String getDummyStackFrameLabel(IStackFrame stackFrame) {
        return DUMMY_STACKFRAME_LABEL;
    }

    private OverlayImageCache getImageCache() {
        return this.imageCache;
    }

    private UIDebugManager getUIDebugManager() {
        if (this.uiDebugManager == null) {
            this.uiDebugManager = PTPDebugUIPlugin.getUIDebugManager();
        }
        return this.uiDebugManager;
    }

    private String getVariableTypeName(IAIF aif) {
        IAIFType type;
        StringBuffer result = new StringBuffer();
        if (aif != null && (type = aif.getType()) != null) {
            result.append(type.toString().trim());
            while (type instanceof IAIFTypeArray) {
                IAIFTypeRange range = ((IAIFTypeArray)type).getRange();
                result.append('[');
                result.append(range.getSize());
                result.append(']');
                type = ((IAIFTypeArray)type).getBaseType();
            }
        }
        return result.toString();
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    protected StringBuffer appendBreakpointStatus(IPBreakpoint breakpoint, StringBuffer label) throws CoreException {
        label.append(" ");
        label.append("{");
        label.append(breakpoint.getJobName());
        label.append(":");
        label.append(breakpoint.getSetId());
        label.append("}");
        return label;
    }

    protected StringBuffer appendLineNumber(IPLineBreakpoint breakpoint, StringBuffer label) throws CoreException {
        int lineNumber = breakpoint.getLineNumber();
        if (lineNumber > 0) {
            label.append(" ");
            label.append(NLS.bind((String)Messages.PDebugModelPresentation_4, (Object[])new Object[]{Integer.toString(lineNumber)}));
        }
        return label;
    }

    protected StringBuffer appendSourceName(IPBreakpoint breakpoint, StringBuffer label, boolean qualified) throws CoreException {
        Path path;
        String handle = breakpoint.getSourceHandle();
        if (!this.isEmpty(handle) && (path = new Path(handle)).isValidPath(handle)) {
            label.append(qualified ? path.toOSString() : path.lastSegment());
        }
        return label;
    }

    protected IBreakpoint getBreakpoint(IMarker marker) {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
    }

    protected Image getBreakpointImage(IPBreakpoint breakpoint) {
        try {
            if (breakpoint instanceof IPLineBreakpoint) {
                return this.getLineBreakpointImage((IPLineBreakpoint)breakpoint);
            }
            if (breakpoint instanceof IPWatchpoint) {
                return this.getWatchpointImage((IPWatchpoint)breakpoint);
            }
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
        return null;
    }

    protected String getBreakpointText(IBreakpoint breakpoint, boolean qualified) throws CoreException {
        if (breakpoint instanceof IPLineBreakpoint) {
            return this.getLineBreakpointText((IPLineBreakpoint)breakpoint, qualified);
        }
        return "";
    }

    protected Image getExpressionImage(IExpression element) {
        return DebugUITools.getImage((String)"IMG_OBJS_EXPRESSION");
    }

    protected Image getLineBreakpointImage(IPLineBreakpoint breakpoint) throws CoreException {
        String job_id = breakpoint.getJobId();
        String cur_job_id = this.getUIDebugManager().getCurrentJobId();
        if (!job_id.equals(IPBreakpoint.GLOBAL) && !job_id.equals(cur_job_id)) {
            return new Image(null, 1, 1);
        }
        String descriptor = null;
        IElementHandler setManager = this.getUIDebugManager().getElementHandler(job_id);
        if (setManager == null) {
            descriptor = breakpoint.isEnabled() ? "bpt_curr_set_enable.gif" : "bpt_curr_set_disable.gif";
        } else {
            IElementSet set;
            String cur_set_id = this.getUIDebugManager().getCurrentSetId();
            String bpt_set_id = breakpoint.getSetId();
            descriptor = bpt_set_id.equals(cur_set_id) ? (breakpoint.isEnabled() ? "bpt_curr_set_enable.gif" : "bpt_curr_set_disable.gif") : ((set = setManager.getSet(bpt_set_id)) == null ? (breakpoint.isEnabled() ? "bpt_curr_set_enable.gif" : "bpt_curr_set_disable.gif") : (set.containsMatchSet(cur_set_id) ? (breakpoint.isEnabled() ? "bpt_multi_set_enable.gif" : "bpt_multi_set_disable.gif") : (breakpoint.isEnabled() ? "bpt_no_set_enable.gif" : "bpt_no_set_disable.gif")));
        }
        return this.getImageCache().getImageFor(new OverlayImageDescriptor(PDebugImage.getImage(descriptor), this.computeBreakpointOverlays((IPBreakpoint)breakpoint)));
    }

    protected String getLineBreakpointText(IPLineBreakpoint breakpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        this.appendSourceName((IPBreakpoint)breakpoint, label, qualified);
        this.appendLineNumber(breakpoint, label);
        this.appendBreakpointStatus((IPBreakpoint)breakpoint, label);
        return label.toString();
    }

    protected Image getModuleImage(IPModule element) {
        switch (element.getType()) {
            case 1: {
                if (element.areSymbolsLoaded()) {
                    return PDebugImage.getImage("no.gif");
                }
                return PDebugImage.getImage("no.gif");
            }
            case 2: {
                if (element.areSymbolsLoaded()) {
                    return PDebugImage.getImage("no.gif");
                }
                return PDebugImage.getImage("no.gif");
            }
        }
        return null;
    }

    protected String getModuleText(IPModule module, boolean qualified) {
        StringBuffer sb = new StringBuffer();
        IPath path = module.getImageName();
        if (!path.isEmpty()) {
            sb.append(path.lastSegment());
        } else {
            sb.append(Messages.PDebugModelPresentation_5);
        }
        return sb.toString();
    }

    protected Image getRegisterGroupImage(IRegisterGroup element) {
        IEnableDisableTarget target = (IEnableDisableTarget)element.getAdapter(IEnableDisableTarget.class);
        if (target != null && !target.isEnabled()) {
            return PDebugImage.getImage("no.gif");
        }
        return PDebugImage.getImage("no.gif");
    }

    protected String getRegisterGroupText(IRegisterGroup group) {
        String name = Messages.PDebugModelPresentation_6;
        try {
            name = group.getName();
        }
        catch (DebugException e) {
            PTPDebugUIPlugin.log(e.getStatus());
        }
        return name;
    }

    protected Image getRegisterImage(IRegister element) {
        return element instanceof IPVariable && ((IPVariable)element).isEnabled() ? PDebugImage.getImage("no.gif") : PDebugImage.getImage("no.gif");
    }

    protected Image getSignalImage(IPSignal signal) {
        return PDebugImage.getImage("no.gif");
    }

    protected String getSignalText(IPSignal signal) {
        StringBuffer sb = new StringBuffer(Messages.PDebugModelPresentation_7);
        try {
            String name = signal.getName();
            sb.append(" '").append(name).append('\'');
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return sb.toString();
    }

    protected String getStackFrameText(IStackFrame f, boolean qualified) throws DebugException {
        if (f instanceof IPStackFrame) {
            IPStackFrame frame = (IPStackFrame)f;
            StringBuffer label = new StringBuffer();
            label.append(frame.getLevel());
            label.append(' ');
            String function = frame.getFunction();
            if (this.isEmpty(function)) {
                label.append(Messages.PDebugModelPresentation_8);
            } else if ((function = function.trim()).length() > 0) {
                Path path;
                label.append(function);
                if (!function.contains("(")) {
                    label.append("()");
                }
                label.append(" ");
                if (frame.getFile() != null && !(path = new Path(frame.getFile())).isEmpty()) {
                    label.append(qualified ? path.toOSString() : path.lastSegment());
                    label.append(':');
                    if (frame.getFrameLineNumber() != 0) {
                        label.append(frame.getFrameLineNumber());
                    }
                }
            }
            BigInteger address = frame.getAddress();
            if (address != null) {
                label.append(' ');
                label.append(address.toString(16));
            }
            return label.toString();
        }
        return f.getAdapter(IPDummyStackFrame.class) != null ? this.getDummyStackFrameLabel(f) : f.getName();
    }

    protected String getTargetText(IDebugTarget target, boolean qualified) throws DebugException {
        IPDebugTarget t = (IPDebugTarget)target.getAdapter(IPDebugTarget.class);
        if (t != null && !t.isPostMortem()) {
            PDebugElementState state = t.getState();
            if (state.equals(PDebugElementState.EXITED)) {
                Object info = t.getCurrentStateInfo();
                String label = Messages.PDebugModelPresentation_9;
                String reason = "";
                if (info != null && info instanceof IPDISignalInfo) {
                    IPDISignalInfo sigInfo = (IPDISignalInfo)info;
                    reason = String.valueOf(' ') + NLS.bind((String)Messages.PDebugModelPresentation_10, (Object[])new Object[]{sigInfo.getName(), sigInfo.getDescription()});
                } else if (info != null && info instanceof IPDIExitInfo) {
                    reason = String.valueOf(' ') + NLS.bind((String)Messages.PDebugModelPresentation_11, (Object[])new Object[]{new Integer(((IPDIExitInfo)info).getCode())});
                }
                return NLS.bind((String)label, (Object[])new Object[]{target.getName(), reason});
            }
            if (state.equals(PDebugElementState.SUSPENDED)) {
                return NLS.bind((String)Messages.PDebugModelPresentation_12, (Object[])new Object[]{target.getName()});
            }
        }
        return target.getName();
    }

    protected String getThreadText(IThread thread, boolean qualified) throws DebugException {
        IPDebugTarget target = (IPDebugTarget)thread.getDebugTarget().getAdapter(IPDebugTarget.class);
        if (target.isPostMortem()) {
            return NLS.bind((String)Messages.PDebugModelPresentation_13, (Object[])new Object[]{thread.getName()});
        }
        if (thread.isTerminated()) {
            return NLS.bind((String)Messages.PDebugModelPresentation_14, (Object[])new Object[]{thread.getName()});
        }
        if (thread.isStepping()) {
            return NLS.bind((String)Messages.PDebugModelPresentation_15, (Object[])new Object[]{thread.getName()});
        }
        if (!thread.isSuspended()) {
            return NLS.bind((String)Messages.PDebugModelPresentation_16, (Object[])new Object[]{thread.getName()});
        }
        if (thread.isSuspended()) {
            String reason = "";
            IPDebugElement element = (IPDebugElement)thread.getAdapter(IPDebugElement.class);
            if (element != null) {
                Object info = element.getCurrentStateInfo();
                if (info != null && info instanceof IPDISignalInfo) {
                    reason = NLS.bind((String)Messages.PDebugModelPresentation_23, (Object[])new Object[]{((IPDISignalInfo)info).getName(), ((IPDISignalInfo)info).getDescription()});
                } else if (info != null && info instanceof IPDIWatchpointTriggerInfo) {
                    reason = NLS.bind((String)Messages.PDebugModelPresentation_17, (Object[])new Object[]{((IPDIWatchpointTriggerInfo)info).getOldValue(), ((IPDIWatchpointTriggerInfo)info).getNewValue()});
                } else if (info != null && info instanceof IPDIWatchpointScopeInfo) {
                    reason = Messages.PDebugModelPresentation_18;
                } else if (info != null && info instanceof IPDIBreakpointInfo) {
                    reason = Messages.PDebugModelPresentation_19;
                } else if (info != null && info instanceof IPDISharedLibraryInfo) {
                    reason = Messages.PDebugModelPresentation_20;
                }
            }
            return NLS.bind((String)Messages.PDebugModelPresentation_21, (Object[])new Object[]{thread.getName(), reason});
        }
        return NLS.bind((String)Messages.PDebugModelPresentation_13, (Object[])new Object[]{thread.getName()});
    }

    protected String getValueText(IValue value) {
        StringBuffer label = new StringBuffer();
        if (value instanceof IPDebugElementStatus && !((IPDebugElementStatus)value).isOK()) {
            label.append(NLS.bind((String)Messages.PDebugModelPresentation_22, (Object[])new Object[]{((IPDebugElementStatus)value).getMessage()}));
        } else if (value instanceof IPValue) {
            IAIF aif = null;
            try {
                aif = ((IPValue)value).getAIF();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
            try {
                String valueString = value.getValueString();
                if (valueString != null) {
                    valueString = valueString.trim();
                    if (aif != null && aif instanceof IAIFTypeChar) {
                        if (valueString.length() == 0) {
                            valueString = ".";
                        }
                        label.append(valueString);
                    } else if ((aif == null || !(aif.getType() instanceof IAIFTypeArray) && !(aif.getType() instanceof IAIFTypeAggregate)) && valueString.length() > 0) {
                        label.append(valueString);
                    }
                }
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return label.toString();
    }

    protected Image getVariableImage(IVariable element) {
        if (element instanceof IPVariable) {
            IAIF aif = null;
            try {
                aif = ((IPVariable)element).getAIF();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
            if (aif == null) {
                return PDebugImage.getImage(((IPVariable)element).isEnabled() ? "no.gif" : "no.gif");
            }
            IAIFType type = aif.getType();
            if (type instanceof IAIFTypePointer || type instanceof IAIFTypeReference) {
                return PDebugImage.getImage(((IPVariable)element).isEnabled() ? "no.gif" : "no.gif");
            }
            if (type instanceof IAIFTypeArray || type instanceof IAIFTypeAggregate) {
                return PDebugImage.getImage(((IPVariable)element).isEnabled() ? "no.gif" : "no.gif");
            }
            return PDebugImage.getImage(((IPVariable)element).isEnabled() ? "no.gif" : "no.gif");
        }
        return null;
    }

    protected String getVariableText(IVariable var) throws DebugException {
        StringBuffer label = new StringBuffer();
        if (var instanceof IPVariable) {
            String valueString;
            String name;
            String typeName;
            IAIF aif = null;
            try {
                aif = ((IPVariable)var).getAIF();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
            if (aif != null && this.isShowVariableTypeNames() && (typeName = this.getVariableTypeName(aif)) != null && typeName.length() > 0) {
                label.append(typeName).append(' ');
            }
            if ((name = var.getName()) != null) {
                label.append(name.trim());
            }
            if (!this.isEmpty(valueString = this.getValueText(var.getValue()))) {
                label.append(" = ");
                label.append(valueString);
            }
        }
        return label.toString();
    }

    protected String getWatchExpressionText(IWatchExpression expression) {
        StringBuffer result = new StringBuffer();
        result.append('\"').append(expression.getExpressionText()).append('\"');
        if (expression.isPending()) {
            result.append(" = ").append(DUMMY_STACKFRAME_LABEL);
        } else {
            IValue value = expression.getValue();
            if (value instanceof IPValue) {
                String valueString;
                String typeName;
                IAIF aif = null;
                try {
                    aif = ((IPValue)value).getAIF();
                }
                catch (DebugException debugException) {
                    // empty catch block
                }
                if (aif != null && this.isShowVariableTypeNames() && !this.isEmpty(typeName = this.getVariableTypeName(aif))) {
                    result.insert(0, String.valueOf(typeName) + ' ');
                }
                if (expression.isEnabled() && (valueString = this.getValueText(value)).length() > 0) {
                    result.append(" = ").append(valueString);
                }
            }
        }
        if (!expression.isEnabled()) {
            result.append(' ');
            result.append(Messages.PDebugModelPresentation_0);
        }
        return result.toString();
    }

    protected Image getWatchpointImage(IPWatchpoint watchpoint) throws CoreException {
        String descriptor = null;
        descriptor = watchpoint.isEnabled() ? (watchpoint.isReadType() && !watchpoint.isWriteType() ? "no.gif" : (!watchpoint.isReadType() && watchpoint.isWriteType() ? "no.gif" : "no.gif")) : (watchpoint.isReadType() && !watchpoint.isWriteType() ? "no.gif" : (!watchpoint.isReadType() && watchpoint.isWriteType() ? "no.gif" : "no.gif"));
        return this.getImageCache().getImageFor(new OverlayImageDescriptor(PDebugImage.getImage(descriptor), this.computeBreakpointOverlays((IPBreakpoint)watchpoint)));
    }

    protected boolean isShowQualifiedNames() {
        Boolean showQualified = (Boolean)this.getAttributes().get(DISPLAY_FULL_PATHS);
        showQualified = showQualified == null ? Boolean.FALSE : showQualified;
        return showQualified;
    }

    protected boolean isShowVariableTypeNames() {
        Boolean show = (Boolean)this.getAttributes().get("org.eclipse.debug.ui.displayVariableTypeNames");
        show = show == null ? Boolean.FALSE : show;
        return show;
    }
}

