/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.fields.proposal.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.AbstractContentProviderAdapter;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class SourceFolderContentProvider
extends AbstractContentProviderAdapter {
    private final Predicate<IJavaElement> m_projectFilter;
    private final Predicate<IPackageFragmentRoot> m_sourceFolderFilter;

    public SourceFolderContentProvider(Predicate<IJavaElement> projectFilter) {
        this.m_projectFilter = projectFilter;
        this.m_sourceFolderFilter = new Predicate<IPackageFragmentRoot>(){

            @Override
            public boolean test(IPackageFragmentRoot element) {
                String srcFolderName = element.getPath().removeFirstSegments(1).toString().toLowerCase();
                return "src/generated/java".equals(srcFolderName) || !srcFolderName.contains("generated");
            }
        };
    }

    @Override
    protected Collection<? extends Object> loadProposals(IProgressMonitor monitor) {
        try {
            IJavaProject[] javaProjects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
            ArrayList<IJavaProject> relevantProjects = new ArrayList<IJavaProject>();
            IJavaProject[] iJavaProjectArray = javaProjects;
            int n = javaProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject jp = iJavaProjectArray[n2];
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                if (this.m_projectFilter == null || this.m_projectFilter.test((IJavaElement)jp)) {
                    relevantProjects.add(jp);
                }
                ++n2;
            }
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            return S2eUtils.getSourceFolders(relevantProjects, this.m_sourceFolderFilter, (IProgressMonitor)monitor);
        }
        catch (JavaModelException | SdkException e) {
            SdkLog.error((String)"Error while calculating possible source folders", (Object[])new Object[]{e});
            return Collections.emptySet();
        }
    }

    public String getText(Object element) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)element;
        return String.valueOf(root.getJavaProject().getElementName()) + '/' + root.getPath().removeFirstSegments(1).toString();
    }
}

