/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.client.launcher;

import javax.print.attribute.standard.Severity;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.launching.EclipseApplicationLaunchConfiguration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtbot.generator.client.Recorder;
import org.eclipse.swtbot.generator.client.views.RecorderClientView;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class RecorderServerLaunchConfiguration
extends EclipseApplicationLaunchConfiguration {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        super.launch(configuration, mode, launch, monitor);
        int port = this.getServerPort(configuration);
        if (port == -1) {
            Status status = new Status(Severity.ERROR.getValue(), "org.eclipse.swtbot.generator.client", "Could not find a port number in the launch arguments");
            throw new CoreException((IStatus)status);
        }
        this.startClientRecorder(port);
    }

    private int getServerPort(ILaunchConfiguration configuration) throws CoreException {
        String launchArguments = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
        String[] vmArguments = launchArguments.split(" ");
        int i = 0;
        while (i < vmArguments.length) {
            String[] portArgumentKeyValue;
            String vmArgument = vmArguments[i];
            if (vmArgument.contains("org.eclipse.swtbot.generator.server.enable") && (portArgumentKeyValue = vmArgument.split("=")).length == 2) {
                return Integer.parseInt(portArgumentKeyValue[1]);
            }
            ++i;
        }
        return -1;
    }

    private void startClientRecorder(final int port) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RecorderClientView view = RecorderServerLaunchConfiguration.this.getRecorderClientView();
                if (view == null || !(view instanceof RecorderClientView)) {
                    try {
                        RecorderServerLaunchConfiguration.this.openRecorderClientView();
                        view = RecorderServerLaunchConfiguration.this.getRecorderClientView();
                    }
                    catch (PartInitException e) {
                        throw new RuntimeException("Could not open RecorderClientView: " + e.getMessage());
                    }
                }
                Recorder.INSTANCE.startRecorderClient(port);
                view.updateUI();
            }
        });
    }

    private RecorderClientView getRecorderClientView() {
        return (RecorderClientView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.swtbot.generator.client.view.recorder.client");
    }

    private void openRecorderClientView() throws PartInitException {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.swtbot.generator.client.view.recorder.client");
    }
}

