/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.forms.parts;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tcf.te.ui.forms.parts.AbstractPartWithButtons;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractStructuredViewerPart
extends AbstractPartWithButtons {
    private StructuredViewer viewer = null;
    private Point minSize = null;

    public AbstractStructuredViewerPart(String[] labels) {
        super(labels);
    }

    public final StructuredViewer getViewer() {
        return this.viewer;
    }

    public void setMinSize(int width, int height) {
        this.minSize = new Point(width, height);
        this.onMinSizeChanged();
    }

    protected void onMinSizeChanged() {
        if (this.minSize != null && this.viewer != null) {
            GridData layoutData = (GridData)this.viewer.getControl().getLayoutData();
            layoutData.widthHint = this.minSize.x;
            layoutData.heightHint = this.minSize.y;
        }
    }

    protected abstract StructuredViewer createStructuredViewer(Composite var1, int var2, FormToolkit var3);

    @Override
    protected void createMainControl(Composite parent, int style, int span, FormToolkit toolkit) {
        this.viewer = this.createStructuredViewer(parent, style, toolkit);
        Assert.isNotNull((Object)this.viewer);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = span;
        this.viewer.getControl().setLayoutData((Object)layoutData);
        this.onMinSizeChanged();
    }

    @Override
    protected void onEnabledStateChanged() {
        if (this.viewer != null) {
            this.viewer.getControl().setEnabled(this.isEnabled());
        }
        super.onEnabledStateChanged();
    }
}

