/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.tm4e.core.model.TMTokenDecodeData;

class DecodeMap {
    int lastAssignedId = 0;
    Map<String, int[]> scopeToTokenIds = new LinkedHashMap<String, int[]>();
    Map<String, Integer> tokenToTokenId = new LinkedHashMap<String, Integer>();
    Map<Integer, String> tokenIdToToken = new LinkedHashMap<Integer, String>();
    TMTokenDecodeData prevToken = new TMTokenDecodeData(new String[0], new LinkedHashMap<Integer, Map<Integer, Boolean>>());

    public int[] getTokenIds(String scope) {
        int[] tokens = this.scopeToTokenIds.get(scope);
        if (tokens != null) {
            return tokens;
        }
        String[] tmpTokens = scope.split("[.]");
        tokens = new int[tmpTokens.length];
        int i = 0;
        while (i < tmpTokens.length) {
            String token = tmpTokens[i];
            Integer tokenId = this.tokenToTokenId.get(token);
            if (tokenId == null) {
                tokenId = ++this.lastAssignedId;
                this.tokenToTokenId.put(token, tokenId);
                this.tokenIdToToken.put(tokenId, token);
            }
            tokens[i] = tokenId;
            ++i;
        }
        this.scopeToTokenIds.put(scope, tokens);
        return tokens;
    }

    public String getToken(Map<Integer, Boolean> tokenMap) {
        StringBuilder result = new StringBuilder();
        boolean isFirst = true;
        int i = 1;
        while (i <= this.lastAssignedId) {
            if (tokenMap.containsKey(i)) {
                if (isFirst) {
                    isFirst = false;
                    result.append(this.tokenIdToToken.get(i));
                } else {
                    result.append('.');
                    result.append(this.tokenIdToToken.get(i));
                }
            }
            ++i;
        }
        return result.toString();
    }
}

