/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlLocation;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.readonly.TmfXmlReadOnlyModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.w3c.dom.Element;

public class XmlTimeGraphEntryModel
extends TimeGraphEntryModel {
    private static final @NonNull String EMPTY_STRING = "";
    private final String fPath;
    private final @NonNull String fXmlId;
    private final @NonNull String fXmlParentId;
    private final boolean fShowText;

    public static XmlTimeGraphEntryModel create(long id, long parentId, String name, long start, long end) {
        return new XmlTimeGraphEntryModel(id, parentId, name, start, end, null, name, EMPTY_STRING, false);
    }

    public XmlTimeGraphEntryModel(long id, long parentId, @NonNull String name, long startTime, long endTime, String path, @NonNull String xmlId, @NonNull String xmlParentId, boolean showText) {
        super(id, parentId, name, startTime, endTime);
        this.fPath = path;
        this.fXmlId = xmlId;
        this.fXmlParentId = xmlParentId;
        this.fShowText = showText;
    }

    public @NonNull String getXmlId() {
        return this.fXmlId;
    }

    public @NonNull String getXmlParentId() {
        return this.fXmlParentId;
    }

    public @Nullable String getPath() {
        return this.fPath;
    }

    public boolean showText() {
        return this.fShowText;
    }

    protected static class Builder
    implements ITimeGraphEntryModel,
    IXmlStateSystemContainer {
        private final long fId;
        private long fParentId;
        private String fName = "";
        private final long fStart;
        private final long fEnd;
        private final @Nullable Element fElement;
        private @NonNull String fXmlId = "";
        private @NonNull String fXmlParentId = "";
        private final @NonNull ITmfStateSystem fSs;

        public Builder(long id, long parentId, @NonNull String name, long entryStart, long entryEnd, @Nullable Element entryElement, @NonNull ITmfStateSystem ss, int baseQuark) {
            this.fId = id;
            this.fParentId = parentId;
            this.fName = name;
            this.fStart = entryStart;
            this.fEnd = entryEnd;
            this.fElement = entryElement;
            this.fSs = ss;
            if (entryElement != null) {
                String nameFromSs;
                List<Element> elements = TmfXmlUtils.getChildElements(this.fElement, "parent");
                if (!elements.isEmpty()) {
                    this.fXmlParentId = this.getFirstValue(baseQuark, Objects.requireNonNull(elements.get(0)));
                }
                if (!(elements = TmfXmlUtils.getChildElements(this.fElement, "name")).isEmpty() && !(nameFromSs = this.getFirstValue(baseQuark, Objects.requireNonNull(elements.get(0)))).isEmpty()) {
                    this.fName = nameFromSs;
                }
                this.fXmlId = !(elements = TmfXmlUtils.getChildElements(this.fElement, "id")).isEmpty() ? this.getFirstValue(baseQuark, Objects.requireNonNull(elements.get(0))) : name;
            }
        }

        private @NonNull String getFirstValue(int baseQuark, @NonNull Element stateAttribute) {
            ITmfStateInterval firstInterval;
            ITmfXmlModelFactory factory = TmfXmlReadOnlyModelFactory.getInstance();
            ITmfXmlStateAttribute display = factory.createStateAttribute(stateAttribute, this);
            int quark = display.getAttributeQuark(baseQuark, null);
            if (quark != -1 && (firstInterval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)this.fSs, (int)quark, (long)this.getStartTime(), (long)this.getEndTime())) != null) {
                return String.valueOf(firstInterval.getValue());
            }
            return XmlTimeGraphEntryModel.EMPTY_STRING;
        }

        public long getId() {
            return this.fId;
        }

        public long getParentId() {
            return this.fParentId;
        }

        public @NonNull String getName() {
            return this.fName;
        }

        public long getStartTime() {
            return this.fStart;
        }

        public long getEndTime() {
            return this.fEnd;
        }

        @Override
        public @NonNull ITmfStateSystem getStateSystem() {
            return this.fSs;
        }

        @Override
        public String getAttributeValue(String name) {
            return name;
        }

        @Override
        public Iterable<TmfXmlLocation> getLocations() {
            return Collections.emptySet();
        }

        public String getXmlId() {
            return this.fXmlId;
        }

        public @NonNull String getXmlParentId() {
            return this.fXmlParentId;
        }

        public void setParentId(long newParentId) {
            this.fParentId = newParentId;
        }

        public XmlTimeGraphEntryModel build() {
            Element element = this.fElement;
            boolean showText = false;
            String path = null;
            if (element != null) {
                showText = Boolean.parseBoolean(element.getAttribute("displayText"));
                path = element.getAttribute("path");
            }
            return new XmlTimeGraphEntryModel(this.fId, this.fParentId, String.valueOf(this.fName), this.fStart, this.fEnd, path, this.fXmlId, this.fXmlParentId, showText);
        }

        public String toString() {
            return String.valueOf(this.fName) + " - " + this.fXmlId + " - " + this.fXmlParentId + " - " + this.fId + " - " + this.fParentId;
        }
    }
}

