/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.callstack;

import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.symbols.IMappingFile;
import org.eclipse.tracecompass.tmf.core.symbols.TmfResolvedSymbol;

public final class MappingFile
implements IMappingFile {
    private static final String DEFAULT_END_SUFFIX = "END__";
    private static Comparator<@NonNull Long> MAP_COMPARATOR = new Comparator<Long>(){

        @Override
        public int compare(Long o1, Long o2) {
            return Long.compareUnsigned(o1, o2);
        }
    };
    private final String fFullPath;
    private final boolean fIsBinaryFile;
    private final NavigableMap<Long, TmfResolvedSymbol> fSymbolMapping;
    private final int fPid;

    public MappingFile(String path, boolean isBinaryFile, Map<Long, TmfResolvedSymbol> results, int pid) {
        this.fFullPath = path;
        this.fIsBinaryFile = isBinaryFile;
        this.fSymbolMapping = new TreeMap<Long, TmfResolvedSymbol>(MAP_COMPARATOR);
        this.fSymbolMapping.putAll(results);
        this.fPid = pid;
    }

    @Override
    public String getFullPath() {
        return this.fFullPath;
    }

    @Override
    public boolean isBinaryFile() {
        return this.fIsBinaryFile;
    }

    private long getLastAddress() {
        return (Long)this.fSymbolMapping.lastKey();
    }

    @Override
    public @Nullable TmfResolvedSymbol getSymbolEntry(long address) {
        Map.Entry<Long, TmfResolvedSymbol> floorEntry = this.fSymbolMapping.floorEntry(address);
        if (floorEntry == null) {
            return null;
        }
        TmfResolvedSymbol symbol = Objects.requireNonNull(floorEntry.getValue());
        long floorValue = symbol.getBaseAddress();
        return (symbol.getSymbolName().endsWith(MappingFile.getEndSuffix()) || floorValue == this.getLastAddress()) && floorValue != address ? null : symbol;
    }

    private static String getEndSuffix() {
        return DEFAULT_END_SUFFIX;
    }

    @Override
    public int getPid() {
        return this.fPid;
    }

    public int hashCode() {
        return Objects.hash(this.fFullPath, this.fIsBinaryFile, this.fSymbolMapping);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MappingFile other = (MappingFile)obj;
        return this.fFullPath.equals(other.fFullPath) && this.fIsBinaryFile == other.fIsBinaryFile && this.fSymbolMapping.equals(other.fSymbolMapping);
    }
}

