/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.memories;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.viatra.query.runtime.matchers.memories.DefaultMaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.memories.IdentityMaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.memories.NullaryMaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.memories.UnaryMaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;

public abstract class MaskedTupleMemory
implements Clearable,
Iterable<Tuple> {
    protected TupleMask mask;
    protected Object owner;

    public static MaskedTupleMemory create(TupleMask mask, CollectionsFactory.MemoryType bucketType, Object owner) {
        if (mask.isIdentity()) {
            return new IdentityMaskedTupleMemory(mask, bucketType, owner);
        }
        if (mask.getSize() == 0) {
            return new NullaryMaskedTupleMemory(mask, bucketType, owner);
        }
        if (1 == mask.getSize()) {
            return new UnaryMaskedTupleMemory(mask, bucketType, owner);
        }
        return new DefaultMaskedTupleMemory(mask, bucketType, owner);
    }

    public Object getOwner() {
        return this.owner;
    }

    public TupleMask getMask() {
        return this.mask;
    }

    public abstract int getKeysetSize();

    public abstract int getTotalSize();

    @Override
    public abstract Iterator<Tuple> iterator();

    public abstract Iterable<Tuple> getSignatures();

    public abstract Collection<Tuple> get(ITuple var1);

    public Collection<Tuple> getOrEmpty(ITuple signature) {
        Collection<Tuple> result = this.get(signature);
        return result == null ? Collections.emptySet() : result;
    }

    public abstract boolean remove(Tuple var1, Tuple var2);

    public abstract boolean remove(Tuple var1);

    public abstract boolean add(Tuple var1, Tuple var2);

    public abstract boolean add(Tuple var1);

    protected MaskedTupleMemory(TupleMask mask, Object owner) {
        this.mask = mask;
        this.owner = owner;
    }

    protected IllegalStateException raiseDuplicateInsertion(Tuple tuple) {
        return new IllegalStateException(String.format("Duplicate insertion of tuple %s into %s", tuple, this.owner));
    }

    protected IllegalStateException raiseDuplicateDeletion(Tuple tuple) {
        return new IllegalStateException(String.format("Duplicate deletion of tuple %s from %s", tuple, this.owner));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "<" + this.mask + ">@" + this.owner;
    }
}

