/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.util;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;

public class MapBackedMemoryView<T>
implements IMemoryView<T> {
    private Map<T, Integer> wrapped;

    protected MapBackedMemoryView(Map<T, Integer> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public Iterator<T> iterator() {
        return this.wrapped.keySet().iterator();
    }

    @Override
    public int getCount(T value) {
        return this.getCountUnsafe(value);
    }

    @Override
    public int getCountUnsafe(Object value) {
        Integer count2 = this.wrapped.get(value);
        return count2 == null ? 0 : count2;
    }

    @Override
    public boolean containsNonZero(T value) {
        return this.wrapped.containsKey(value);
    }

    @Override
    public boolean containsNonZeroUnsafe(Object value) {
        return this.wrapped.containsKey(value);
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public Set<T> distinctValues() {
        return this.wrapped.keySet();
    }

    @Override
    public void forEachEntryWithMultiplicities(BiConsumer<T, Integer> entryConsumer) {
        for (Map.Entry<T, Integer> entry : this.wrapped.entrySet()) {
            entryConsumer.accept(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Iterable<Map.Entry<T, Integer>> entriesWithMultiplicities() {
        return this.wrapped.entrySet();
    }

    public int hashCode() {
        return IMemoryView.hashCode(this);
    }

    public boolean equals(Object obj) {
        return IMemoryView.equals(this, obj);
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

