/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.boundary.InputConnector;
import org.eclipse.viatra.query.runtime.rete.matcher.ReteEngine;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.NodeFactory;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.viatra.query.runtime.rete.remote.Address;
import org.eclipse.viatra.query.runtime.rete.traceability.RecipeTraceInfo;

public class Network {
    final int threads;
    protected ArrayList<ReteContainer> containers;
    ReteContainer headContainer;
    private int firstContainer = 0;
    private int nextContainer = 0;
    protected Map<ReteContainer, Long> globalTerminationCriteria = null;
    protected Map<ReteContainer, Long> reportedClocks = null;
    protected Lock updateLock = null;
    protected Lock structuralChangeLock = null;
    private ReteEngine engine;
    protected NodeFactory nodeFactory;
    protected InputConnector inputConnector;
    Map<ReteNodeRecipe, Address<? extends Node>> nodesByRecipe = CollectionsFactory.createMap();
    Set<RecipeTraceInfo> recipeTraces = CollectionsFactory.createSet();

    public synchronized Address<? extends Node> getExistingNodeByRecipe(ReteNodeRecipe recipe) {
        Address<? extends Node> node = this.nodesByRecipe.get(recipe);
        if (node == null) {
            throw new IllegalStateException(String.format("Rete node for recipe %s not constructed yet.", recipe));
        }
        return node;
    }

    public synchronized Address<? extends Node> getNodeByRecipeIfExists(ReteNodeRecipe recipe) {
        Address<? extends Node> node = this.nodesByRecipe.get(recipe);
        return node;
    }

    public Network(int threads, ReteEngine engine) {
        this.threads = threads;
        this.engine = engine;
        this.inputConnector = new InputConnector(this);
        this.nodeFactory = new NodeFactory(engine.getLogger());
        this.containers = new ArrayList();
        this.nextContainer = this.firstContainer = threads > 1 ? 0 : 0;
        if (threads > 0) {
            this.globalTerminationCriteria = CollectionsFactory.createMap();
            this.reportedClocks = CollectionsFactory.createMap();
            ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
            this.updateLock = rwl.readLock();
            this.structuralChangeLock = rwl.writeLock();
            int i = 0;
            while (i < threads) {
                this.containers.add(new ReteContainer(this, true));
                ++i;
            }
        } else {
            this.containers.add(new ReteContainer(this, false));
        }
        this.headContainer = this.containers.get(0);
    }

    public void kill() {
        for (ReteContainer container : this.containers) {
            container.kill();
        }
        this.containers.clear();
    }

    public ReteContainer getHeadContainer() {
        return this.headContainer;
    }

    public ReteContainer getNextContainer() {
        if (this.nextContainer >= this.containers.size()) {
            this.nextContainer = this.firstContainer;
        }
        return this.containers.get(this.nextContainer++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUpdate(Address<? extends Receiver> receiver, Direction direction, Tuple updateElement) {
        ReteContainer affectedContainer = receiver.getContainer();
        Map<ReteContainer, Long> map = this.globalTerminationCriteria;
        synchronized (map) {
            long newCriterion = affectedContainer.sendUpdateToLocalAddress(receiver, direction, updateElement);
            this.terminationCriterion(affectedContainer, newCriterion);
        }
    }

    private void sendUpdateSingleThreaded(Address<? extends Receiver> receiver, Direction direction, Tuple updateElement) {
        ReteContainer affectedContainer = receiver.getContainer();
        affectedContainer.sendUpdateToLocalAddressSingleThreaded(receiver, direction, updateElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUpdates(Address<? extends Receiver> receiver, Direction direction, Collection<Tuple> updateElements) {
        if (updateElements.isEmpty()) {
            return;
        }
        ReteContainer affectedContainer = receiver.getContainer();
        Map<ReteContainer, Long> map = this.globalTerminationCriteria;
        synchronized (map) {
            long newCriterion = affectedContainer.sendUpdatesToLocalAddress(receiver, direction, updateElements);
            this.terminationCriterion(affectedContainer, newCriterion);
        }
    }

    public void sendExternalUpdate(Address<? extends Receiver> receiver, Direction direction, Tuple updateElement) {
        if (this.threads > 0) {
            try {
                this.updateLock.lock();
                this.sendUpdate(receiver, direction, updateElement);
            }
            finally {
                this.updateLock.unlock();
            }
        } else {
            this.sendUpdateSingleThreaded(receiver, direction, updateElement);
        }
    }

    public void sendConstructionUpdate(Address<? extends Receiver> receiver, Direction direction, Tuple updateElement) {
        if (this.threads > 0) {
            this.sendUpdate(receiver, direction, updateElement);
        } else {
            receiver.getContainer().sendUpdateToLocalAddressSingleThreaded(receiver, direction, updateElement);
        }
    }

    public void sendConstructionUpdates(Address<? extends Receiver> receiver, Direction direction, Collection<Tuple> updateElements) {
        if (this.threads > 0) {
            this.sendUpdates(receiver, direction, updateElements);
        } else {
            receiver.getContainer().sendUpdatesToLocalAddressSingleThreaded(receiver, direction, updateElements);
        }
    }

    public void connectRemoteNodes(Address<? extends Supplier> supplier, Address<? extends Receiver> receiver, boolean synchronise) {
        try {
            if (this.threads > 0) {
                this.structuralChangeLock.lock();
            }
            receiver.getContainer().connectRemoteNodes(supplier, receiver, synchronise);
        }
        finally {
            if (this.threads > 0) {
                this.structuralChangeLock.unlock();
            }
        }
    }

    public void disconnectRemoteNodes(Address<? extends Supplier> supplier, Address<? extends Receiver> receiver, boolean desynchronise) {
        try {
            if (this.threads > 0) {
                this.structuralChangeLock.lock();
            }
            receiver.getContainer().disconnectRemoteNodes(supplier, receiver, desynchronise);
        }
        finally {
            if (this.threads > 0) {
                this.structuralChangeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportLocalUpdateTermination(ReteContainer reportingContainer, long clock, Map<ReteContainer, Long> localTerminationCriteria) {
        Map<ReteContainer, Long> map = this.globalTerminationCriteria;
        synchronized (map) {
            for (Map.Entry<ReteContainer, Long> entry : localTerminationCriteria.entrySet()) {
                this.terminationCriterion(entry.getKey(), entry.getValue());
            }
            this.reportedClocks.put(reportingContainer, clock);
            Long l = this.globalTerminationCriteria.get(reportingContainer);
            if (l != null && l < clock) {
                this.globalTerminationCriteria.remove(reportingContainer);
            }
            if (this.globalTerminationCriteria.isEmpty()) {
                this.globalTerminationCriteria.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminationCriterion(ReteContainer affectedContainer, long newCriterion) {
        Map<ReteContainer, Long> map = this.globalTerminationCriteria;
        synchronized (map) {
            long relevantClock;
            Long oldCriterion = this.globalTerminationCriteria.get(affectedContainer);
            Long oldClock = this.reportedClocks.get(affectedContainer);
            long l = relevantClock = oldClock == null ? 0L : oldClock;
            if (relevantClock <= newCriterion && (oldCriterion == null || oldCriterion < newCriterion)) {
                this.globalTerminationCriteria.put(affectedContainer, newCriterion);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForReteTermination() {
        if (this.threads <= 0) {
            this.headContainer.deliverMessagesSingleThreaded();
            return;
        }
        Map<ReteContainer, Long> map = this.globalTerminationCriteria;
        synchronized (map) {
            while (true) {
                if (this.globalTerminationCriteria.isEmpty()) {
                    return;
                }
                try {
                    this.globalTerminationCriteria.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForReteTermination(Runnable action) {
        if (this.threads <= 0) {
            this.headContainer.deliverMessagesSingleThreaded();
            action.run();
            return;
        }
        Map<ReteContainer, Long> map = this.globalTerminationCriteria;
        synchronized (map) {
            while (true) {
                if (this.globalTerminationCriteria.isEmpty()) {
                    action.run();
                    return;
                }
                try {
                    this.globalTerminationCriteria.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public Set<RecipeTraceInfo> getRecipeTraces() {
        return Collections.unmodifiableSet(this.recipeTraces);
    }

    public List<ReteContainer> getContainers() {
        return Collections.unmodifiableList(this.containers);
    }

    public Lock getStructuralChangeLock() {
        return this.structuralChangeLock;
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public InputConnector getInputConnector() {
        return this.inputConnector;
    }

    public ReteEngine getEngine() {
        return this.engine;
    }
}

