/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageTwo;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.wizards.DesignerNewElementWizard;
import org.eclipse.wb.internal.core.wizards.Messages;

public class DesignerJavaProjectWizard
extends DesignerNewElementWizard
implements IExecutableExtension {
    private NewJavaProjectWizardPageOne fFirstPage;
    private NewJavaProjectWizardPageTwo fSecondPage;
    private IConfigurationElement fConfigElement;

    public DesignerJavaProjectWizard() {
        this.setDialogSettings(DesignerPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(Messages.DesignerJavaProjectWizard_title);
    }

    public void addPages() {
        this.fFirstPage = new NewJavaProjectWizardPageOne();
        this.addPage((IWizardPage)this.fFirstPage);
        this.fSecondPage = new NewJavaProjectWizardPageTwo(this.fFirstPage);
        this.addPage((IWizardPage)this.fSecondPage);
        this.fFirstPage.init(this.getSelection(), this.getActivePart());
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fSecondPage.performFinish(monitor);
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            IWorkingSet[] workingSets = this.fFirstPage.getWorkingSets();
            if (workingSets.length > 0) {
                IJavaProject newElement = this.getCreatedElement();
                PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)newElement, workingSets);
            }
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            BasicNewResourceWizard.selectAndReveal((IResource)this.fSecondPage.getJavaProject().getProject(), (IWorkbenchWindow)DesignerPlugin.getActiveWorkbenchWindow());
        }
        return res;
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchPage activePage = DesignerPlugin.getActivePage();
        if (activePage != null) {
            return activePage.getActivePart();
        }
        return null;
    }

    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        String title = Messages.DesignerJavaProjectWizard_errorTitle;
        String message = Messages.DesignerJavaProjectWizard_errorMessage;
        DesignerNewElementWizard.ExceptionHandler.perform(e, this.getShell(), title, message);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        this.fSecondPage.performCancel();
        return super.performCancel();
    }

    public IJavaProject getCreatedElement() {
        return this.fSecondPage.getJavaProject();
    }
}

