/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model;

import java.util.List;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.swing.MigLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.MigLayout.model.MigColumnInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigRowInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swing.model.util.surround.LayoutSurroundSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MigLayoutSurroundSupport
extends LayoutSurroundSupport {
    static final String CELLS_KEY = "SurroundSupport_CELLS";
    private final MigLayoutInfo m_layout;
    private Rectangle m_enclosingCells;

    public MigLayoutSurroundSupport(MigLayoutInfo layout) {
        super((LayoutInfo)layout);
        this.m_layout = layout;
    }

    protected boolean validateComponents(List<ComponentInfo> components) throws Exception {
        this.m_enclosingCells = MigLayoutSurroundSupport.getCells(components.get(0));
        for (ComponentInfo component : components) {
            this.m_enclosingCells.union(MigLayoutSurroundSupport.getCells(component));
        }
        for (ComponentInfo component : this.m_layout.getContainer().getChildrenComponents()) {
            if (components.contains(component) || !this.m_enclosingCells.intersects(MigLayoutSurroundSupport.getCells(component))) continue;
            return false;
        }
        return super.validateComponents(components);
    }

    protected void addContainer(ContainerInfo container, List<ComponentInfo> components) throws Exception {
        container.putArbitraryValue((Object)CELLS_KEY, (Object)this.m_enclosingCells);
        JavaInfoUtils.setParameter((JavaInfo)container, (String)"gridLayout.grabHorizontal", (String)"false");
        JavaInfoUtils.setParameter((JavaInfo)container, (String)"gridLayout.grabVertical", (String)"false");
        this.m_layout.command_CREATE((ComponentInfo)container, this.m_enclosingCells.x, false, this.m_enclosingCells.y, false);
        MigLayoutSurroundSupport.setCells((ComponentInfo)container, this.m_enclosingCells);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)container);
        constraints.setHorizontalAlignment(MigColumnInfo.Alignment.FILL);
        constraints.setVerticalAlignment(MigRowInfo.Alignment.FILL);
        constraints.write();
    }

    protected void moveDone(ContainerInfo container, List<ComponentInfo> components) throws Exception {
        super.moveDone((AbstractComponentInfo)container, components);
        this.m_layout.normalizeSpanning();
    }

    static void setCells(ComponentInfo component, Rectangle cells) throws Exception {
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(component);
        constraints.setX(cells.x);
        constraints.setY(cells.y);
        constraints.setWidth(cells.width);
        constraints.setHeight(cells.height);
        constraints.write();
    }

    static Rectangle getCells(ComponentInfo component) throws Exception {
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(component);
        return new Rectangle(constraints.getX(), constraints.getY(), constraints.getWidth(), constraints.getHeight());
    }
}

