/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.document;

import java.util.Enumeration;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONObject;
import org.eclipse.wst.json.core.internal.document.ISourceGenerator;
import org.eclipse.wst.json.core.internal.document.JSONModelImpl;
import org.eclipse.wst.json.core.internal.document.JSONNodeImpl;
import org.eclipse.wst.json.core.internal.document.JSONObjectImpl;
import org.eclipse.wst.json.core.internal.document.JSONStructureImpl;
import org.eclipse.wst.json.core.internal.document.StructuredDocumentRegionContainer;
import org.eclipse.wst.json.core.internal.document.StructuredDocumentRegionManagementException;
import org.eclipse.wst.json.core.internal.document.StructuredDocumentRegionProxy;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class JSONModelUpdater {
    private int diff = 0;
    private int gapLength = 0;
    private int gapOffset = 0;
    private IStructuredDocumentRegion gapStructuredDocumentRegion = null;
    private ISourceGenerator generator = null;
    private JSONModelImpl model = null;
    private JSONNodeImpl nextNode = null;
    private JSONNodeImpl parentNode = null;

    protected JSONModelUpdater(JSONModelImpl model) {
        if (model != null) {
            this.model = model;
            this.generator = model.getGenerator();
        }
    }

    void changeRegion(RegionChangedEvent change, IStructuredDocumentRegion flatNode, ITextRegion region) {
        JSONNodeImpl root;
        if (change.getOffset() >= flatNode.getStartOffset() + region.getTextEnd()) {
            return;
        }
        this.parentNode = root = (JSONNodeImpl)((Object)this.model.getDocument());
        this.nextNode = (JSONNodeImpl)root.getFirstChild();
        this.removeGapStructuredDocumentRegion(flatNode);
        this.insertGapStructuredDocumentRegionBefore(flatNode.getStart());
        this.changeStructuredDocumentRegion(flatNode);
        this.insertGapStructuredDocumentRegionAfter(flatNode.getEnd());
    }

    void changeStartTag(IJSONObject element) {
        int offset;
        IJSONNode parent;
        if (element == null) {
            return;
        }
        JSONObjectImpl impl = (JSONObjectImpl)element;
        if (!impl.hasStartTag() && !impl.hasEndTag() && (parent = element.getParentNode()) != null) {
            this.replaceChild(parent, element, element);
            return;
        }
        String source = this.generator.generateStartTag(element);
        if (source == null) {
            return;
        }
        int length = source.length();
        if (length == 0) {
            return;
        }
        int start = offset = impl.getStartOffset();
        int end = offset;
        if (impl.hasStartTag()) {
            end = impl.getStartEndOffset();
            this.gapStructuredDocumentRegion = impl.getStartStructuredDocumentRegion();
        }
        impl.setStartStructuredDocumentRegion(new StructuredDocumentRegionProxy(offset, length));
        this.replaceSource(source, start, end);
    }

    private void changeStructuredDocumentRegion(IStructuredDocumentRegion oldStructuredDocumentRegion) {
        if (oldStructuredDocumentRegion == null) {
            return;
        }
        if (this.parentNode == null) {
            return;
        }
        int oldOffset = oldStructuredDocumentRegion.getStart();
        oldStructuredDocumentRegion.getEnd();
        boolean isEndTag = false;
        JSONNodeImpl ownerNode = null;
        while (this.parentNode != null) {
            IJSONObject element;
            IStructuredDocumentRegion endStructuredDocumentRegion;
            if (this.nextNode != null) {
                IJSONNode child;
                IStructuredDocumentRegion nextStructuredDocumentRegion = this.nextNode.getStructuredDocumentRegion();
                if (nextStructuredDocumentRegion != null) {
                    if (nextStructuredDocumentRegion == oldStructuredDocumentRegion) {
                        ownerNode = this.nextNode;
                        break;
                    }
                    int nextOffset = nextStructuredDocumentRegion.getStart();
                    if (nextOffset == oldOffset) {
                        ownerNode = this.nextNode;
                        break;
                    }
                }
                if ((child = this.nextNode.getFirstChild()) != null) {
                    this.parentNode = this.nextNode;
                    this.nextNode = (JSONNodeImpl)child;
                    continue;
                }
                if (this.nextNode.getNodeType() == 0) {
                    this.parentNode = this.nextNode;
                    this.nextNode = null;
                    continue;
                }
                this.nextNode = (JSONNodeImpl)this.nextNode.getNextSibling();
                if (this.nextNode != null) continue;
            }
            if (this.parentNode.getNodeType() == 0 && (endStructuredDocumentRegion = (element = (IJSONObject)((Object)this.parentNode)).getEndStructuredDocumentRegion()) != null) {
                if (endStructuredDocumentRegion == oldStructuredDocumentRegion) {
                    ownerNode = this.parentNode;
                    isEndTag = true;
                    break;
                }
                int endOffset = endStructuredDocumentRegion.getStart();
                if (endOffset == oldOffset) {
                    ownerNode = this.parentNode;
                    isEndTag = true;
                    break;
                }
            }
            this.nextNode = (JSONNodeImpl)this.parentNode.getNextSibling();
            this.parentNode = (JSONNodeImpl)this.parentNode.getParentNode();
        }
        if (ownerNode == null) {
            throw new StructuredDocumentRegionManagementException();
        }
        short nodeType = ownerNode.getNodeType();
        if (nodeType == 0) {
            JSONObjectImpl element = (JSONObjectImpl)ownerNode;
            if (isEndTag) {
                element.setEndStructuredDocumentRegion(oldStructuredDocumentRegion);
            } else {
                element.setStartStructuredDocumentRegion(oldStructuredDocumentRegion);
                this.updateAttrRegions(element, oldStructuredDocumentRegion);
            }
        } else {
            ownerNode.setStructuredDocumentRegion(oldStructuredDocumentRegion);
        }
    }

    void changeValue(IJSONNode node) {
        if (node == null) {
            return;
        }
        if (this.getStructuredDocument() == null) {
            return;
        }
        short nodeType = node.getNodeType();
        if (nodeType == 0) {
            this.changeStartTag((IJSONObject)node);
            return;
        }
        String source = this.generator.generateSource(node);
        if (source == null) {
            source = "";
        }
        int length = source.length();
        JSONNodeImpl impl = (JSONNodeImpl)node;
        int start = impl.getStartOffset();
        int end = impl.getEndOffset();
        this.gapStructuredDocumentRegion = impl.getStructuredDocumentRegion();
        StructuredDocumentRegionProxy flatNode = null;
        if (length > 0) {
            flatNode = new StructuredDocumentRegionProxy(start, length);
        }
        impl.setStructuredDocumentRegion(flatNode);
        this.replaceSource(source, start, end);
    }

    private IStructuredDocument getStructuredDocument() {
        if (this.model == null) {
            return null;
        }
        return this.model.getStructuredDocument();
    }

    void initialize() {
        this.gapStructuredDocumentRegion = null;
        this.gapOffset = 0;
        this.gapLength = 0;
        this.diff = 0;
        this.parentNode = null;
        this.nextNode = null;
    }

    private void insertGapStructuredDocumentRegionAfter(int endOffset) {
        if (this.gapStructuredDocumentRegion == null) {
            return;
        }
        if (this.gapStructuredDocumentRegion instanceof StructuredDocumentRegionProxy) {
            StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)this.gapStructuredDocumentRegion;
            IStructuredDocumentRegion flatNode = proxy.getStructuredDocumentRegion();
            if (flatNode != null) {
                this.insertStructuredDocumentRegion(flatNode);
            }
        } else if (this.gapStructuredDocumentRegion instanceof StructuredDocumentRegionContainer) {
            StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)this.gapStructuredDocumentRegion;
            int count = container.getStructuredDocumentRegionCount();
            int i = 0;
            while (i < count) {
                IStructuredDocumentRegion content = container.getStructuredDocumentRegion(i);
                if (content != null && content.getStart() >= endOffset) {
                    if (content instanceof StructuredDocumentRegionProxy) {
                        StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)content;
                        IStructuredDocumentRegion flatNode = proxy.getStructuredDocumentRegion();
                        if (flatNode != null) {
                            this.insertStructuredDocumentRegion(flatNode);
                        }
                    } else {
                        this.insertStructuredDocumentRegion(content);
                    }
                }
                ++i;
            }
        } else {
            this.insertStructuredDocumentRegion(this.gapStructuredDocumentRegion);
        }
    }

    private void insertGapStructuredDocumentRegionBefore(int startOffset) {
        if (this.gapStructuredDocumentRegion == null) {
            return;
        }
        if (this.gapStructuredDocumentRegion instanceof StructuredDocumentRegionProxy) {
            StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)this.gapStructuredDocumentRegion;
            IStructuredDocumentRegion flatNode = proxy.getStructuredDocumentRegion();
            if (flatNode != null) {
                this.insertStructuredDocumentRegion(flatNode);
            }
        } else if (this.gapStructuredDocumentRegion instanceof StructuredDocumentRegionContainer) {
            StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)this.gapStructuredDocumentRegion;
            int count = container.getStructuredDocumentRegionCount();
            int i = 0;
            while (i < count) {
                IStructuredDocumentRegion content = container.getStructuredDocumentRegion(i);
                if (content != null) {
                    if (content.getStart() >= startOffset) {
                        return;
                    }
                    if (content instanceof StructuredDocumentRegionProxy) {
                        StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)content;
                        IStructuredDocumentRegion flatNode = proxy.getStructuredDocumentRegion();
                        if (flatNode != null) {
                            this.insertStructuredDocumentRegion(flatNode);
                        }
                    } else {
                        this.insertStructuredDocumentRegion(content);
                    }
                }
                ++i;
            }
        } else {
            this.insertStructuredDocumentRegion(this.gapStructuredDocumentRegion);
        }
    }

    private void insertStructuredDocumentRegion(IStructuredDocumentRegion newStructuredDocumentRegion) {
        if (newStructuredDocumentRegion == null) {
            return;
        }
        if (this.parentNode == null) {
            return;
        }
        int newOffset = newStructuredDocumentRegion.getStart();
        newStructuredDocumentRegion.getEnd();
        boolean isEndTag = false;
        JSONNodeImpl ownerNode = null;
        while (this.parentNode != null) {
            int endOffset;
            IJSONObject element;
            IStructuredDocumentRegion endStructuredDocumentRegion;
            if (this.nextNode != null) {
                int nextOffset;
                IStructuredDocumentRegion nextStructuredDocumentRegion = this.nextNode.getStructuredDocumentRegion();
                if (nextStructuredDocumentRegion != null && (nextOffset = nextStructuredDocumentRegion.getStart()) == newOffset) {
                    ownerNode = this.nextNode;
                    break;
                }
                IJSONNode child = this.nextNode.getFirstChild();
                if (child != null) {
                    this.parentNode = this.nextNode;
                    this.nextNode = (JSONNodeImpl)child;
                    continue;
                }
                if (this.nextNode.getNodeType() == 0) {
                    this.parentNode = this.nextNode;
                    this.nextNode = null;
                    continue;
                }
                this.nextNode = (JSONNodeImpl)this.nextNode.getNextSibling();
                if (this.nextNode != null) continue;
            }
            if (this.parentNode.getNodeType() == 0 && (endStructuredDocumentRegion = (element = (IJSONObject)((Object)this.parentNode)).getEndStructuredDocumentRegion()) != null && (endOffset = endStructuredDocumentRegion.getStart()) == newOffset) {
                ownerNode = this.parentNode;
                isEndTag = true;
                break;
            }
            this.nextNode = (JSONNodeImpl)this.parentNode.getNextSibling();
            this.parentNode = (JSONNodeImpl)this.parentNode.getParentNode();
        }
        if (ownerNode == null) {
            throw new StructuredDocumentRegionManagementException();
        }
        short nodeType = ownerNode.getNodeType();
        if (nodeType == 0) {
            JSONObjectImpl element = (JSONObjectImpl)ownerNode;
            if (isEndTag) {
                element.setEndStructuredDocumentRegion(newStructuredDocumentRegion);
            } else {
                element.setStartStructuredDocumentRegion(newStructuredDocumentRegion);
                this.updateAttrRegions(element, newStructuredDocumentRegion);
            }
        } else {
            ownerNode.setStructuredDocumentRegion(newStructuredDocumentRegion);
        }
    }

    private void removeGapStructuredDocumentRegion(IStructuredDocumentRegion oldStructuredDocumentRegion) {
        if (this.gapStructuredDocumentRegion == null) {
            return;
        }
        if (this.gapStructuredDocumentRegion == oldStructuredDocumentRegion) {
            this.gapStructuredDocumentRegion = null;
            return;
        }
        if (this.gapStructuredDocumentRegion instanceof StructuredDocumentRegionProxy) {
            StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)this.gapStructuredDocumentRegion;
            IStructuredDocumentRegion flatNode = proxy.getStructuredDocumentRegion();
            if (flatNode == oldStructuredDocumentRegion) {
                this.gapStructuredDocumentRegion = null;
            }
        } else if (this.gapStructuredDocumentRegion instanceof StructuredDocumentRegionContainer) {
            StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)this.gapStructuredDocumentRegion;
            int count = container.getStructuredDocumentRegionCount();
            int i = 0;
            while (i < count) {
                IStructuredDocumentRegion content = container.getStructuredDocumentRegion(i);
                if (content != null) {
                    StructuredDocumentRegionProxy proxy;
                    if (content == oldStructuredDocumentRegion) {
                        if (count > 1) {
                            container.removeStructuredDocumentRegion(i);
                        } else {
                            this.gapStructuredDocumentRegion = null;
                        }
                        return;
                    }
                    if (content instanceof StructuredDocumentRegionProxy && (proxy = (StructuredDocumentRegionProxy)content).getStructuredDocumentRegion() == oldStructuredDocumentRegion) {
                        if (count > 1) {
                            container.removeStructuredDocumentRegion(i);
                        } else {
                            this.gapStructuredDocumentRegion = null;
                        }
                        return;
                    }
                }
                ++i;
            }
        }
    }

    private void removeStructuredDocumentRegion(IStructuredDocumentRegion oldStructuredDocumentRegion) {
        if (oldStructuredDocumentRegion == null) {
            return;
        }
        if (this.parentNode == null) {
            return;
        }
        int gapEnd = this.gapOffset + this.gapLength;
        int oldOffset = oldStructuredDocumentRegion.getStart();
        int oldEnd = oldStructuredDocumentRegion.getEnd();
        if (oldOffset >= this.gapOffset && oldEnd <= gapEnd) {
            return;
        }
        int oldLength = oldEnd - oldOffset;
        if (oldOffset >= gapEnd) {
            oldOffset += this.diff;
        }
        JSONNodeImpl ownerNode = null;
        JSONStructureImpl ownerEndTag = null;
        while (this.parentNode != null) {
            JSONObjectImpl element;
            if (this.nextNode != null) {
                if (this.nextNode.getStructuredDocumentRegion() == oldStructuredDocumentRegion) {
                    ownerNode = this.nextNode;
                    break;
                }
                IJSONNode child = this.nextNode.getFirstChild();
                if (child != null) {
                    this.parentNode = this.nextNode;
                    this.nextNode = (JSONNodeImpl)child;
                    continue;
                }
                if (this.nextNode.getNodeType() == 0) {
                    this.parentNode = this.nextNode;
                    this.nextNode = null;
                    continue;
                }
                this.nextNode = (JSONNodeImpl)this.nextNode.getNextSibling();
                if (this.nextNode != null) continue;
            }
            if (this.parentNode.getNodeType() == 0 && (element = (JSONObjectImpl)this.parentNode).getEndStructuredDocumentRegion() == oldStructuredDocumentRegion) {
                ownerNode = this.parentNode;
                ownerEndTag = element;
                break;
            }
            this.nextNode = (JSONNodeImpl)this.parentNode.getNextSibling();
            this.parentNode = (JSONNodeImpl)this.parentNode.getParentNode();
        }
        if (ownerNode == null) {
            throw new StructuredDocumentRegionManagementException();
        }
        StructuredDocumentRegionProxy newStructuredDocumentRegion = new StructuredDocumentRegionProxy(oldOffset, oldLength);
        if (ownerEndTag != null) {
            ownerEndTag.setEndStructuredDocumentRegion(newStructuredDocumentRegion);
        } else {
            ownerNode.setStructuredDocumentRegion(newStructuredDocumentRegion);
        }
    }

    void replaceAttr(IJSONObject ownerIJSONObject, IJSONNode newAttr, IJSONNode oldAttr) {
        if (ownerIJSONObject == null) {
            return;
        }
        if (this.getStructuredDocument() == null) {
            return;
        }
        JSONObjectImpl element = (JSONObjectImpl)ownerIJSONObject;
        if (!element.hasStartTag()) {
            this.changeStartTag(element);
            return;
        }
    }

    protected boolean isNestedTagClose(String regionType) {
        boolean result = false;
        return result;
    }

    void replaceChild(IJSONNode parentNode, IJSONNode newChild, IJSONNode oldChild) {
        if (parentNode == null) {
            return;
        }
        if (newChild == null && oldChild == null) {
            return;
        }
        if (this.getStructuredDocument() == null) {
            return;
        }
        int start = 0;
        int end = 0;
        String preTag = null;
        String postTag = null;
        JSONStructureImpl postIJSONObject = null;
        if (oldChild != null) {
            JSONNodeImpl node = (JSONNodeImpl)oldChild;
            start = node.getStartOffset();
            end = node.getEndOffset();
            node.resetStructuredDocumentRegions();
        } else {
            JSONNodeImpl prev = (JSONNodeImpl)newChild.getPreviousSibling();
            if (prev != null) {
                end = start = prev.getEndOffset();
            } else {
                JSONNodeImpl next = (JSONNodeImpl)newChild.getNextSibling();
                if (next != null) {
                    end = start = next.getStartOffset();
                    parentNode.getNodeType();
                } else if (parentNode.getNodeType() == 0) {
                    IJSONObject cfr_ignored_0 = (IJSONObject)parentNode;
                }
            }
        }
        String source = null;
        if (newChild != null) {
            int length;
            int length2;
            StringBuffer buffer = new StringBuffer();
            int offset = start;
            if (preTag != null && (length2 = preTag.length()) > 0) {
                offset += length2;
                buffer.append(preTag);
            }
            JSONNodeImpl node = (JSONNodeImpl)newChild;
            block0: while (node != null) {
                StructuredDocumentRegionProxy flatNode;
                if (node.getNodeType() == 0) {
                    int length3;
                    JSONObjectImpl element = (JSONObjectImpl)node;
                    StructuredDocumentRegionProxy flatNode2 = null;
                    String startTag = this.generator.generateStartTag(element);
                    if (startTag != null && (length3 = startTag.length()) > 0) {
                        buffer.append(startTag);
                        flatNode2 = new StructuredDocumentRegionProxy(offset, length3);
                        offset += length3;
                    }
                    element.setStartStructuredDocumentRegion(flatNode2);
                } else {
                    String content = this.generator.generateSource(node);
                    if (content == null) {
                        content = "";
                    }
                    int length4 = content.length();
                    flatNode = null;
                    if (length4 > 0) {
                        buffer.append(content);
                        flatNode = new StructuredDocumentRegionProxy(offset, length4);
                        offset += length4;
                    }
                    node.setStructuredDocumentRegion(flatNode);
                }
                JSONNodeImpl child = (JSONNodeImpl)node.getFirstChild();
                if (child != null) {
                    node = child;
                    continue;
                }
                if (node.getNodeType() == 0) {
                    int length5;
                    JSONObjectImpl element = (JSONObjectImpl)node;
                    flatNode = null;
                    String endTag = this.generator.generateEndTag(element);
                    if (endTag != null && (length5 = endTag.length()) > 0) {
                        buffer.append(endTag);
                        flatNode = new StructuredDocumentRegionProxy(offset, length5);
                        offset += length5;
                    }
                    element.setEndStructuredDocumentRegion(flatNode);
                }
                while (node != null) {
                    int length6;
                    if (node == newChild) {
                        node = null;
                        continue block0;
                    }
                    JSONNodeImpl next = (JSONNodeImpl)node.getNextSibling();
                    if (next != null) {
                        node = next;
                        continue block0;
                    }
                    if ((node = (JSONNodeImpl)node.getParentNode()).getNodeType() != 0) continue;
                    JSONObjectImpl element = (JSONObjectImpl)node;
                    StructuredDocumentRegionProxy flatNode3 = null;
                    String endTag = this.generator.generateEndTag(element);
                    if (endTag != null && (length6 = endTag.length()) > 0) {
                        buffer.append(endTag);
                        flatNode3 = new StructuredDocumentRegionProxy(offset, length6);
                        offset += length6;
                    }
                    element.setEndStructuredDocumentRegion(flatNode3);
                }
            }
            if (postTag != null && (length = postTag.length()) > 0) {
                buffer.append(postTag);
                if (postIJSONObject != null) {
                    StructuredDocumentRegionProxy flatNode = new StructuredDocumentRegionProxy(offset, length);
                    postIJSONObject.setEndStructuredDocumentRegion(flatNode);
                }
            }
            source = buffer.toString();
        }
        if (start == end && (source == null || source.length() == 0)) {
            return;
        }
        this.replaceSource(source, start, end);
    }

    void replaceRegions(IStructuredDocumentRegion flatNode, ITextRegionList newRegions, ITextRegionList oldRegions) {
        JSONNodeImpl root;
        this.parentNode = root = (JSONNodeImpl)((Object)this.model.getDocument());
        this.nextNode = (JSONNodeImpl)root.getFirstChild();
        this.removeGapStructuredDocumentRegion(flatNode);
        this.insertGapStructuredDocumentRegionBefore(flatNode.getStart());
        this.changeStructuredDocumentRegion(flatNode);
        this.insertGapStructuredDocumentRegionAfter(flatNode.getEnd());
    }

    private void replaceSource(String source, int start, int end) {
        int inserted = 0;
        if (source == null) {
            source = "";
        } else {
            inserted = source.length();
        }
        int removed = end - start;
        if (inserted == 0 && removed == 0) {
            return;
        }
        this.gapOffset = start;
        this.gapLength = removed;
        this.diff = inserted - removed;
        this.getStructuredDocument().replaceText((Object)this.model, this.gapOffset, this.gapLength, source, true);
    }

    void replaceStructuredDocumentRegions(IStructuredDocumentRegionList newStructuredDocumentRegions, IStructuredDocumentRegionList oldStructuredDocumentRegions) {
        JSONNodeImpl root = (JSONNodeImpl)((Object)this.model.getDocument());
        if (oldStructuredDocumentRegions != null) {
            this.parentNode = root;
            this.nextNode = (JSONNodeImpl)root.getFirstChild();
            Enumeration e = oldStructuredDocumentRegions.elements();
            while (e.hasMoreElements()) {
                IStructuredDocumentRegion flatNode = (IStructuredDocumentRegion)e.nextElement();
                if (flatNode == null) continue;
                this.removeStructuredDocumentRegion(flatNode);
                this.removeGapStructuredDocumentRegion(flatNode);
            }
        }
        if (newStructuredDocumentRegions != null) {
            this.parentNode = root;
            this.nextNode = (JSONNodeImpl)root.getFirstChild();
            IStructuredDocumentRegion lastStructuredDocumentRegion = null;
            Enumeration e = newStructuredDocumentRegions.elements();
            while (e.hasMoreElements()) {
                IStructuredDocumentRegion flatNode = (IStructuredDocumentRegion)e.nextElement();
                if (flatNode == null) continue;
                if (lastStructuredDocumentRegion == null) {
                    this.insertGapStructuredDocumentRegionBefore(flatNode.getStart());
                }
                this.insertStructuredDocumentRegion(flatNode);
                lastStructuredDocumentRegion = flatNode;
            }
            if (lastStructuredDocumentRegion != null) {
                this.insertGapStructuredDocumentRegionAfter(lastStructuredDocumentRegion.getEnd());
            } else {
                this.insertGapStructuredDocumentRegionBefore(this.gapOffset);
                this.insertGapStructuredDocumentRegionAfter(this.gapOffset);
            }
        } else {
            this.parentNode = root;
            this.nextNode = (JSONNodeImpl)root.getFirstChild();
            this.insertGapStructuredDocumentRegionBefore(this.gapOffset);
            this.insertGapStructuredDocumentRegionAfter(this.gapOffset);
        }
    }

    private void updateAttrRegions(IJSONObject element, IStructuredDocumentRegion flatNode) {
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
    }
}

