/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.testing.typesystem;

import com.google.common.annotations.Beta;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.testing.util.ParseHelper;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.util.ReflectExtensions;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.CompoundReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.RootResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeData;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.junit.Assert;
import org.junit.ComparisonFailure;

@Singleton
@Beta
public class Oven
extends Assert {
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    @Extension
    private ReflectExtensions _reflectExtensions;
    @Inject
    @Extension
    private ParseHelper<EObject> _parseHelper;

    public void fireproof(CharSequence input) throws Exception {
        this.fireproof(input.toString());
    }

    public void fireproof(String input) throws Exception {
        try {
            EObject file = this._parseHelper.parse((CharSequence)input);
            IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes(file);
            Assert.assertNotNull((Object)resolvedTypes);
            if (file != null) {
                Iterable _iterable = IteratorExtensions.toIterable((Iterator)file.eAllContents());
                for (EObject content : _iterable) {
                    boolean _matched = false;
                    if (content instanceof XAbstractFeatureCall) {
                        XExpression _implicitFirstArgument;
                        boolean _tripleNotEquals_1;
                        boolean _tripleNotEquals;
                        _matched = true;
                        this.assertExpressionTypeIsResolved((XExpression)content, resolvedTypes);
                        XExpression _implicitReceiver = ((XAbstractFeatureCall)content).getImplicitReceiver();
                        boolean bl = _tripleNotEquals = _implicitReceiver != null;
                        if (_tripleNotEquals) {
                            this.assertExpressionTypeIsResolved(((XAbstractFeatureCall)content).getImplicitReceiver(), resolvedTypes);
                        }
                        boolean bl2 = _tripleNotEquals_1 = (_implicitFirstArgument = ((XAbstractFeatureCall)content).getImplicitFirstArgument()) != null;
                        if (_tripleNotEquals_1) {
                            this.assertExpressionTypeIsResolved(((XAbstractFeatureCall)content).getImplicitFirstArgument(), resolvedTypes);
                        }
                    }
                    if (!_matched && content instanceof XClosure) {
                        _matched = true;
                        this.assertExpressionTypeIsResolved((XExpression)content, resolvedTypes);
                        Consumer<JvmFormalParameter> _function = it -> this.assertIdentifiableTypeIsResolved((JvmIdentifiableElement)it, resolvedTypes);
                        ((XClosure)content).getImplicitFormalParameters().forEach(_function);
                    }
                    if (!_matched && content instanceof XExpression) {
                        _matched = true;
                        this.assertExpressionTypeIsResolved((XExpression)content, resolvedTypes);
                    }
                    if (_matched || !(content instanceof JvmIdentifiableElement)) continue;
                    _matched = true;
                    this.assertIdentifiableTypeIsResolved((JvmIdentifiableElement)content, resolvedTypes);
                }
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Throwable) {
                Throwable e = _t;
                String _message = e.getMessage();
                ComparisonFailure error = new ComparisonFailure(_message, input, "");
                error.setStackTrace(e.getStackTrace());
                throw error;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public void assertExpressionTypeIsResolved(XExpression expression, IResolvedTypes types) {
        try {
            Object internalTypes = this._reflectExtensions.invoke((Object)types, "delegate", new Object[0]);
            TypeData _switchResult = null;
            boolean _matched = false;
            if (internalTypes instanceof CompoundReentrantTypeResolver) {
                _matched = true;
                TypeData _xblockexpression = null;
                Method method = CompoundReentrantTypeResolver.class.getDeclaredMethod("getDelegate", XExpression.class);
                method.setAccessible(true);
                Object delegate = method.invoke(internalTypes, expression);
                TypeData _xifexpression = null;
                if (delegate instanceof RootResolvedTypes) {
                    Object _invoke = this._reflectExtensions.invoke(delegate, "getTypeData", new Object[]{expression, Boolean.FALSE});
                    _xifexpression = (TypeData)_invoke;
                }
                _switchResult = _xblockexpression = _xifexpression;
            }
            if (!_matched) {
                Object _invoke = this._reflectExtensions.invoke(internalTypes, "getTypeData", new Object[]{expression, Boolean.FALSE});
                _switchResult = (TypeData)_invoke;
            }
            TypeData type = _switchResult;
            String _string = expression.toString();
            String _plus = "Type is not resolved. Expression: " + _string;
            boolean _xifexpression = false;
            _xifexpression = expression instanceof XAbstractFeatureCall ? ((XAbstractFeatureCall)expression).isPackageFragment() || type != null : type != null;
            Assert.assertTrue((String)_plus, (boolean)_xifexpression);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void assertIdentifiableTypeIsResolved(JvmIdentifiableElement identifiable, IResolvedTypes types) {
        boolean _tripleEquals;
        String _simpleName = identifiable.getSimpleName();
        boolean bl = _tripleEquals = _simpleName == null;
        if (_tripleEquals) {
            return;
        }
        LightweightTypeReference type = types.getActualType(identifiable);
        Assert.assertNotNull((String)identifiable.toString(), (Object)type);
        String _string = identifiable.toString();
        String _plus = _string + " / ";
        String _plus_1 = _plus + type;
        Assert.assertNotNull((String)_plus_1, (Object)type.getIdentifier());
    }
}

