/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.adapters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public class AdapterRegistry {
    public static final AdapterRegistry INSTANCE = new AdapterRegistry();
    HashMap<Object, List<AdapterFactory>> fKeyToAdapterFactory = new HashMap();
    IAdapterManager fAdapterManager = Platform.isRunning() ? Platform.getAdapterManager() : AdapterManager.getDefault();

    AdapterRegistry() {
    }

    public void registerAdapterFactory(EClass key, AdapterFactory factory) {
        this.registerFactory(key, factory);
    }

    public void registerAdapterFactory(EPackage key, AdapterFactory factory) {
        this.registerFactory(key, factory);
    }

    public void unregisterAdapterFactory(EClass key, AdapterFactory factory) {
        this.unregisterFactory(key, factory);
    }

    public void unregisterAdapterFactory(EPackage key, AdapterFactory factory) {
        this.unregisterFactory(key, factory);
    }

    synchronized void registerFactory(Object key, AdapterFactory factory) {
        List<AdapterFactory> list = this.fKeyToAdapterFactory.get(key);
        if (list == null) {
            list = new ArrayList<AdapterFactory>();
            this.fKeyToAdapterFactory.put(key, list);
            list.add(factory);
        } else if (!list.contains(factory)) {
            list.add(factory);
        }
    }

    synchronized void unregisterFactory(Object key, AdapterFactory factory) {
        List<AdapterFactory> list = this.fKeyToAdapterFactory.get(key);
        if (list == null) {
            return;
        }
        list.remove(factory);
    }

    Class<?> adapterInterface(Object type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof String) {
            try {
                return Class.forName((String)type);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Adapter type " + type + " is not understood.");
    }

    public <T> T adapt(Object target, Class<T> clazz) {
        return this.adapt(target, clazz, true);
    }

    public <T> T adapt(Object target, Class<T> clazz, boolean checkWSAdapters) {
        if (target == null) {
            return null;
        }
        if (clazz.isInstance(target)) {
            return clazz.cast(target);
        }
        Object adapter = null;
        if (target instanceof EObject) {
            EObject eObj = (EObject)target;
            EClass effectiveClass = eObj.eClass();
            List<AdapterFactory> list = this.fKeyToAdapterFactory.get(effectiveClass);
            if (list != null) {
                for (AdapterFactory factory : list) {
                    adapter = factory.adapt(target, clazz);
                    if (adapter == null || !clazz.isInstance(adapter)) continue;
                    return clazz.cast(adapter);
                }
            }
            if ((list = this.fKeyToAdapterFactory.get(effectiveClass.getEPackage())) != null) {
                for (AdapterFactory factory : list) {
                    adapter = factory.adapt(target, clazz);
                    if (adapter == null || !clazz.isInstance(adapter)) continue;
                    return clazz.cast(adapter);
                }
            }
        }
        if (checkWSAdapters && this.fAdapterManager != null && (adapter = this.fAdapterManager.getAdapter(target, clazz)) != null && clazz.isInstance(adapter)) {
            return clazz.cast(adapter);
        }
        return null;
    }

    public Object adapt(Object target, Object type) {
        if (target == null) {
            return null;
        }
        return this.adapt(target, this.adapterInterface(type));
    }

    public Object adapt(Object target, Object type, Object context) {
        Object adapter = this.adapt(target, type);
        if (adapter == null) {
            return adapter;
        }
        if (target instanceof EObject) {
            EObject eObject = (EObject)target;
            NotificationImpl n = new NotificationImpl(101, null, context);
            eObject.eNotify((Notification)n);
        }
        return adapter;
    }

    public void registerAdapterFactory(IAdapterFactory factory) {
        this.registerAdapterFactory(factory, Object.class);
    }

    public void registerAdapterFactory(IAdapterFactory factory, Class<?> clazz) {
        this.fAdapterManager.registerAdapters(factory, clazz);
    }
}

