/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.xpath0;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.IModelQuery;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.Validator;

public class XPathValidator
extends Validator {
    String exprString;
    String exprStringTrimmed;
    protected String fNodeName;
    protected String fExprByNode;
    protected INode fParentNode;
    protected XPathExpression xpathExpression;

    @Override
    public void start() {
        super.start();
        this.exprString = this.mModelQuery.lookup(this.mNode, 2, null, null);
        this.exprStringTrimmed = this.exprString.trim();
        this.fNodeName = this.toString(this.mNode.nodeName());
        this.fParentNode = this.mNode.parentNode();
        this.fExprByNode = "text.node." + this.mNode.nodeName().getLocalPart();
    }

    @ARule(desc="XPath sanity check", author="michal.chmielewski@oracle.com", date="02/16/2007", errors="XPATH_EMPTY_EXPRESSION")
    public void rule_SanityCheck_1() {
        if (XPathValidator.isEmptyOrWhitespace(this.exprString)) {
            IProblem problem = this.createError();
            problem.fill("XPATH_EMPTY_EXPRESSION", this.fNodeName, this.fExprByNode);
            this.exprString = null;
            this.disableRules();
        }
    }

    @ARule(desc="XPath syntax check", author="michal.chmielewski@oracle.com", date="02/16/2007", errors="XPATH_EXPRESSION_SYNTAX")
    public void rule_CheckExpressionSyntax_2() {
        if (this.exprString == null) {
            return;
        }
        try {
            XPathFactory factory = XPathFactory.newInstance();
            this.xpathExpression = factory.newXPath().compile(this.exprString);
        }
        catch (XPathExpressionException e) {
            String message = this.getMessageFrom(e);
            IProblem problem = this.createError();
            problem.fill("XPATH_EXPRESSION_SYNTAX", this.fNodeName, this.exprStringTrimmed, this.fExprByNode, message);
            this.disableRules();
        }
    }

    public void rule_ExpressionType_999999() {
        this.setValue("expression.type", null);
    }

    String getMessageFrom(Throwable t) {
        int i = 10;
        while (t.getCause() != null && i > 0) {
            t = t.getCause();
            --i;
        }
        return t.getMessage();
    }

    protected void repointOffsets(IProblem problem, int offset, int offsetEnd) {
        int charStart = this.mModelQuery.lookup(this.mNode, 6, -1);
        int charEnd = this.mModelQuery.lookup(this.mNode, 7, -1);
        int lineNo = this.mModelQuery.lookup(this.mNode, 4, -1);
        int columnNo = this.mModelQuery.lookup(this.mNode, 5, -1);
        if (charStart < 0 || charEnd < 0) {
            return;
        }
        charStart += offset;
        charEnd += offsetEnd;
        int i = 0;
        int j = Math.min(this.exprString.length(), offset);
        while (i < j) {
            if (this.exprString.charAt(i) == '\n') {
                ++charStart;
                if (lineNo > 0) {
                    ++lineNo;
                }
                columnNo = 0;
            }
            if (columnNo >= 0) {
                ++columnNo;
            }
            ++i;
        }
        i = 0;
        j = Math.min(this.exprString.length(), offsetEnd);
        while (i < j) {
            if (this.exprString.charAt(i) == '\n') {
                ++charEnd;
            }
            ++i;
        }
        problem.setAttribute("charStart", charStart);
        problem.setAttribute("charEnd", charEnd);
        if (lineNo > 0) {
            problem.setAttribute("lineNumber", lineNo);
        }
        if (columnNo > 0) {
            problem.setAttribute("columnNumber", columnNo);
        }
    }

    @ARule(sa=0, desc="Create the static analysis visitor for expression analysis", author="michal.chmielewski@oracle.com", date="01/30/2007", errors="XPATH_EXPRESSION_SYNTAX,XPATH_EXPRESSION_TYPE,XPATH_FN_ARGS,XPATH_FN_LITERAL_ARGS,XPATH_UNDEF_VARIABLE,XPATH_UNRESOLVED_NAMESPACE_PREFIXXPATH_INVALID_VARREF_PREFIX,XPATH_VARIABLE_PART,XPATH_UNDEF_VARIABLE_PARTXPATH_FUNCTION_MIN_ARGS,XPATH_FUNCTION_MAX_ARGS,XPATH_EMPTY_EXPRESSION", warnings="XPATH_URI_SYNTAX,XPATH_FUNCTION_UNKNOWN,XPATH_FUNCTION_DEPRECATED,XPATH_EXPRESSION_TYPE")
    public void rule_StaticXPathExpressionAnalysis_10() {
    }

    public void checkDeadlineExpression() {
    }

    public void checkDurationExpression() {
    }

    public void checkBooleanExpression() {
    }

    public void checkIntegerExpression() {
    }

    boolean isNamespaceOK(QName qname) {
        if (qname == null) {
            return false;
        }
        return XPathValidator.isEmpty(qname.getNamespaceURI()) == XPathValidator.isEmpty(qname.getPrefix());
    }

    protected boolean isJoinCondition() {
        return ND_JOIN_CONDITION.equals(this.mNode.nodeName());
    }

    protected IModelQuery getModelQuery() {
        return this.mModelQuery;
    }

    protected INode getNode() {
        return this.mNode;
    }

    @Override
    protected IProblem createError() {
        return super.createError();
    }

    @Override
    protected IProblem createInfo() {
        return super.createInfo();
    }

    @Override
    protected IProblem createWarning() {
        return super.createWarning();
    }

    @Override
    protected void runRules(String tag, Object ... args) {
        super.runRules(tag, args);
    }

    protected boolean duplicateThing(String ... args) {
        String key = null;
        if (args.length == 1) {
            key = args[0];
        } else {
            StringBuilder sb = new StringBuilder();
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String a = stringArray[n2];
                sb.append(a);
                ++n2;
            }
            key = sb.toString();
        }
        if (this.containsValueKey(key)) {
            return true;
        }
        this.setValue(key, Boolean.TRUE);
        return false;
    }

    protected boolean checkPrefix(String prefix, String name) {
        if (XPathValidator.isEmptyOrWhitespace(prefix)) {
            return true;
        }
        String nsURI = this.lookupNamespace(prefix);
        if (XPathValidator.isEmpty(nsURI)) {
            IProblem problem = this.createError();
            problem.fill("XPATH_UNRESOLVED_NAMESPACE_PREFIX", prefix, name);
            return false;
        }
        return true;
    }

    protected String lookupNamespace(String prefix) {
        return this.mModelQuery.lookup(this.mNode, 0, prefix, null);
    }
}

