/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.compare;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.compare.CDOCompareUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewOpener;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.compare.scope.AbstractComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOComparisonScope
extends AbstractComparisonScope {
    private static final CDOViewOpener DEFAULT_VIEW_OPENER = CDOCompareUtil.DEFAULT_VIEW_OPENER;
    private boolean resolveProxies = true;

    public CDOComparisonScope(Notifier left, Notifier right, Notifier origin) {
        super(left, right, origin);
    }

    public Iterator<? extends Resource> getCoveredResources(ResourceSet resourceSet) {
        return Collections.emptyList().iterator();
    }

    public Iterator<? extends EObject> getCoveredEObjects(Resource resource) {
        return Collections.emptyList().iterator();
    }

    public final boolean isResolveProxies() {
        return this.resolveProxies;
    }

    public final void setResolveProxies(boolean resolveProxies) {
        this.resolveProxies = resolveProxies;
    }

    private static CDOView openOriginView(CDOView leftView, CDOView rightView, CDOView[] originView, CDOViewOpener viewOpener) {
        if (leftView.getSession() != rightView.getSession()) {
            throw new IllegalArgumentException("Sessions are different");
        }
        if (originView != null) {
            if (originView.length != 1) {
                throw new IllegalArgumentException("originView.length != 1");
            }
            if (originView[0] != null) {
                throw new IllegalArgumentException("originView[0] != null");
            }
            CDOBranchPoint ancestor = CDOBranchUtil.getAncestor((CDOBranchPoint)leftView, (CDOBranchPoint)rightView);
            if (!ancestor.equals(leftView) && !ancestor.equals(rightView)) {
                if (viewOpener == DEFAULT_VIEW_OPENER) {
                    viewOpener = leftView.getSession();
                }
                originView[0] = viewOpener.openView(ancestor, (ResourceSet)new ResourceSetImpl());
                return originView[0];
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AllContents
    extends CDOComparisonScope {
        public AllContents(Notifier left, Notifier right, Notifier origin) {
            super(left, right, origin);
        }

        public Iterator<? extends EObject> getChildren(EObject eObject) {
            return EcoreUtil.getAllProperContents((EObject)eObject, (boolean)this.isResolveProxies());
        }

        public static AllContents create(CDOObject left, CDOView rightView, CDOView[] originView) {
            return AllContents.create(left, rightView, originView, DEFAULT_VIEW_OPENER);
        }

        public static AllContents create(CDOObject left, CDOView rightView, CDOView[] originView, CDOViewOpener viewOpener) {
            CDOView leftView = left.cdoView();
            CDOView view = CDOComparisonScope.openOriginView(leftView, rightView, originView, viewOpener);
            CDOObject right = CDOUtil.getCDOObject((EObject)rightView.getObject((EObject)left));
            CDOObject origin = view == null ? null : CDOUtil.getCDOObject((EObject)view.getObject((EObject)left));
            return new AllContents((Notifier)left, (Notifier)right, (Notifier)origin);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Minimal
    extends CDOComparisonScope
    implements Predicate<EObject> {
        private Set<CDOID> ids;

        public Minimal(CDOView leftView, CDOView rightView, CDOView originView, Set<CDOID> ids) {
            super((Notifier)Minimal.getRoot(leftView), (Notifier)Minimal.getRoot(rightView), (Notifier)Minimal.getRoot(originView));
            this.ids = ids;
            HashSet<CDOID> requiredParentIDs = new HashSet<CDOID>();
            for (CDOID id : ids) {
                this.collectRequiredParentID(leftView, id, requiredParentIDs);
                this.collectRequiredParentID(rightView, id, requiredParentIDs);
                if (originView == null) continue;
                this.collectRequiredParentID(originView, id, requiredParentIDs);
            }
            ids.addAll(requiredParentIDs);
            CDOResource rootResource = (CDOResource)this.getLeft();
            ids.remove(rootResource.cdoID());
        }

        public Iterator<? extends EObject> getChildren(EObject eObject) {
            return new AbstractTreeIterator<EObject>((Object)eObject, false){
                private static final long serialVersionUID = 1L;

                public Iterator<EObject> getChildren(Object object) {
                    if (object instanceof Resource) {
                        Iterator iterator = ((Resource)object).getContents().iterator();
                        return Iterators.filter((Iterator)iterator, (Predicate)Minimal.this);
                    }
                    EcoreUtil.ProperContentIterator iterator = new EcoreUtil.ProperContentIterator((EObject)object, Minimal.this.isResolveProxies());
                    return Iterators.filter((Iterator)iterator, (Predicate)Minimal.this);
                }
            };
        }

        public boolean apply(EObject input) {
            CDOObject object = CDOUtil.getCDOObject((EObject)input);
            CDOID id = object.cdoID();
            return this.ids.contains(id);
        }

        private void collectRequiredParentIDs(CDOObject object, Set<CDOID> requiredParentIDs) {
            CDORevisionData revisionData;
            CDOID resourceID;
            CDOState state = object.cdoState();
            if (state == CDOState.TRANSIENT) {
                return;
            }
            CDOView view = object.cdoView();
            if (state == CDOState.PROXY) {
                CDOUtil.load((EObject)object, (CDOView)view);
            }
            if (!CDOIDUtil.isNull((CDOID)(resourceID = (revisionData = object.cdoRevision().data()).getResourceID()))) {
                this.collectRequiredParentIDs(view, resourceID, requiredParentIDs);
            } else {
                Object containerOrID = revisionData.getContainerID();
                CDOID containerID = containerOrID instanceof EObject ? (CDOID)((InternalCDOView)object.cdoView()).convertObjectToID(containerOrID) : (CDOID)containerOrID;
                this.collectRequiredParentIDs(view, containerID, requiredParentIDs);
            }
        }

        private void collectRequiredParentIDs(CDOView view, CDOID id, Set<CDOID> requiredParentIDs) {
            if (!CDOIDUtil.isNull((CDOID)id) && !this.ids.contains(id) && requiredParentIDs.add(id)) {
                this.collectRequiredParentID(view, id, requiredParentIDs);
            }
        }

        protected void collectRequiredParentID(CDOView view, CDOID id, Set<CDOID> requiredParentIDs) {
            try {
                CDOObject object = view.getObject(id);
                if (object != null) {
                    this.collectRequiredParentIDs(object, requiredParentIDs);
                }
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        }

        public static IComparisonScope create(CDOView leftView, CDOView rightView, CDOView[] originView) {
            return Minimal.create(leftView, rightView, originView, DEFAULT_VIEW_OPENER);
        }

        public static IComparisonScope create(CDOView leftView, CDOView rightView, CDOView[] originView, CDOViewOpener viewOpener) {
            CDOView view = CDOComparisonScope.openOriginView(leftView, rightView, originView, viewOpener);
            Set<CDOID> ids = Minimal.getAffectedIDs(leftView, rightView, view);
            Minimal.addDirtyIDs(ids, leftView);
            Minimal.addDirtyIDs(ids, rightView);
            return new Minimal(leftView, rightView, view, ids);
        }

        public static IComparisonScope create(CDOView leftView, CDOView rightView, CDOView[] originView, Set<CDOID> ids) {
            return Minimal.create(leftView, rightView, originView, ids, DEFAULT_VIEW_OPENER);
        }

        public static IComparisonScope create(CDOView leftView, CDOView rightView, CDOView[] originView, Set<CDOID> ids, CDOViewOpener viewOpener) {
            CDOView view = CDOComparisonScope.openOriginView(leftView, rightView, originView, viewOpener);
            return new Minimal(leftView, rightView, view, ids);
        }

        public static IComparisonScope create(CDOTransaction transaction) {
            return Minimal.create(transaction, DEFAULT_VIEW_OPENER);
        }

        public static IComparisonScope create(CDOTransaction transaction, CDOViewOpener viewOpener) {
            if (viewOpener == null) {
                viewOpener = transaction.getSession();
            }
            CDOBranchPoint lastUpdate = transaction.getBranch().getPoint(transaction.getLastUpdateTime());
            CDOView lastView = viewOpener.openView(lastUpdate, (ResourceSet)new ResourceSetImpl());
            HashSet<CDOID> ids = new HashSet<CDOID>();
            ids.addAll(transaction.getNewObjects().keySet());
            ids.addAll(transaction.getDirtyObjects().keySet());
            ids.addAll(transaction.getDetachedObjects().keySet());
            return new Minimal((CDOView)transaction, lastView, null, ids);
        }

        private static Set<CDOID> getAffectedIDs(CDOView leftView, CDOView rightView, CDOView originView) {
            if (originView != null) {
                InternalCDOSession session = (InternalCDOSession)leftView.getSession();
                InternalCDOSession.MergeData mergeData = session.getMergeData((CDOBranchPoint)leftView, (CDOBranchPoint)rightView, (CDOBranchPoint)originView, false);
                return mergeData.getIDs();
            }
            CDOChangeSetData changeSetData = leftView.compareRevisions((CDOBranchPoint)rightView);
            return new HashSet<CDOID>(changeSetData.getChangeKinds().keySet());
        }

        private static void addDirtyIDs(Set<CDOID> ids, CDOView view) {
            if (view instanceof CDOTransaction) {
                CDOChangeSetData changeSetData = ((CDOTransaction)view).getChangeSetData();
                Minimal.addDirtyIDs(ids, changeSetData.getNewObjects());
                Minimal.addDirtyIDs(ids, changeSetData.getChangedObjects());
                Minimal.addDirtyIDs(ids, changeSetData.getDetachedObjects());
            }
        }

        private static void addDirtyIDs(Set<CDOID> ids, List<? extends CDOIDAndVersion> keys) {
            for (CDOIDAndVersion cDOIDAndVersion : keys) {
                ids.add(cDOIDAndVersion.getID());
            }
        }

        private static CDOResource getRoot(CDOView view) {
            if (view == null) {
                return null;
            }
            return view.getRootResource();
        }
    }
}

