/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.editor.view;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.edit.spi.DeleteService;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;

public class ViewEditorActionBarContributor
extends EditingDomainActionBarContributor {
    protected DeleteAction createDeleteAction() {
        return new DeleteServiceAction();
    }

    protected CopyAction createCopyAction() {
        return new CopyViewTreeAction();
    }

    protected PasteAction createPasteAction() {
        return new PasteViewTreeAction();
    }

    protected CutAction createCutAction() {
        return new CutViewTreeAction();
    }

    protected <T> T getService(Class<T> serviceType) {
        ViewModelContext context = this.getViewModelContext();
        return (T)(context == null ? null : context.getService(serviceType));
    }

    protected ViewModelContext getViewModelContext() {
        return this.activeEditor == null ? null : (ViewModelContext)this.activeEditor.getAdapter(ViewModelContext.class);
    }

    private boolean isViewTreeActive() {
        return Display.getCurrent().getFocusControl() instanceof Tree;
    }

    private class CopyViewTreeAction
    extends CopyAction {
        private CopyViewTreeAction() {
        }

        public boolean isEnabled() {
            return ViewEditorActionBarContributor.this.isViewTreeActive() && super.isEnabled();
        }
    }

    private class CutViewTreeAction
    extends CutAction {
        private CutViewTreeAction() {
        }

        public boolean isEnabled() {
            return ViewEditorActionBarContributor.this.isViewTreeActive() && super.isEnabled();
        }
    }

    private class DeleteServiceAction
    extends DeleteAction {
        DeleteServiceAction() {
        }

        public void run() {
            DeleteService deleteService = ViewEditorActionBarContributor.this.getService(DeleteService.class);
            if (deleteService == null) {
                super.run();
            } else {
                List selection = this.getStructuredSelection().toList();
                deleteService.deleteElements((Collection)selection);
            }
        }

        public boolean updateSelection(IStructuredSelection selection) {
            DeleteService deleteService = ViewEditorActionBarContributor.this.getService(DeleteService.class);
            if (deleteService == null) {
                return super.updateSelection(selection);
            }
            return !selection.isEmpty() && Stream.of(selection.toArray()).noneMatch(this::isRoot);
        }

        private boolean isRoot(Object object) {
            return object instanceof EObject && ((EObject)object).eContainer() == null;
        }
    }

    private class PasteViewTreeAction
    extends PasteAction {
        private PasteViewTreeAction() {
        }

        public boolean isEnabled() {
            return ViewEditorActionBarContributor.this.isViewTreeActive() && super.isEnabled();
        }
    }
}

