/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.operations;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;

public class AddContentChildOperation
extends AbstractOperation
implements ITransactionalOperation {
    private final IContentPart<? extends Node> parent;
    private final Object contentChild;
    private int index;
    private List<Object> initialContentChildren;

    public AddContentChildOperation(IContentPart<? extends Node> parent, Object contentChild, int index) {
        super("Add Content Child");
        this.parent = parent;
        this.contentChild = contentChild;
        this.index = index;
        this.initialContentChildren = ImmutableList.copyOf(parent.getContentChildrenUnmodifiable());
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.parent.getContent() != null && !this.parent.getContentChildrenUnmodifiable().contains(this.contentChild)) {
            this.parent.addContentChild(this.contentChild, this.index);
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean isContentRelevant() {
        return true;
    }

    @Override
    public boolean isNoOp() {
        return this.initialContentChildren.contains(this.contentChild);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.parent.getContent() != null && this.parent.getContentChildrenUnmodifiable().contains(this.contentChild)) {
            this.parent.removeContentChild(this.contentChild);
        }
        return Status.OK_STATUS;
    }
}

