/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.inspector.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyHierarchyHandler
extends AbstractHandler {
    private static final String PATH_SEPARATOR = "/";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structSel;
        Object firstElement;
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (firstElement = (structSel = (IStructuredSelection)selection).getFirstElement()) instanceof TreeNode) {
            StringBuilder sb = new StringBuilder();
            TreeNode node = (TreeNode)firstElement;
            while (node != null) {
                String nodeString = this.getString(node);
                if (nodeString != null) {
                    sb.insert(0, nodeString);
                    sb.insert(0, PATH_SEPARATOR);
                }
                node = node.getParent();
            }
            sb.delete(0, PATH_SEPARATOR.length());
            if (sb.length() > 0) {
                Clipboard cb = new Clipboard(HandlerUtil.getActiveShellChecked((ExecutionEvent)event).getDisplay());
                cb.setContents((Object[])new String[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
                cb.dispose();
            }
        }
        return null;
    }

    private String getString(TreeNode node) {
        String[] strArray;
        Object value = node.getValue();
        if (value instanceof String[] && (strArray = (String[])value).length > 0) {
            return strArray[0];
        }
        return null;
    }
}

