/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui.internal.handlers;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ldt.core.buildpath.LuaExecutionEnvironment;
import org.eclipse.ldt.core.internal.buildpath.LuaExecutionEnvironmentBuildpathUtil;
import org.eclipse.ldt.ui.internal.handlers.Messages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class LuaExecutionEnvironmentBuildpathContainerDocumentationCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IPath path = this.getExecutionEnvironmentContainer(event);
        if (path == null) {
            return null;
        }
        try {
            LuaExecutionEnvironment ee = LuaExecutionEnvironmentBuildpathUtil.getExecutionEnvironment((IPath)path);
            if (ee != null && ee.getDocumentationPath().length > 0) {
                IPath docPath = ee.getDocumentationPath()[0].append("index.html");
                URL firstUrl = docPath.toFile().toURI().toURL();
                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(firstUrl);
                return null;
            }
        }
        catch (MalformedURLException e) {
            throw new ExecutionException(Messages.LuaExecutionEnvironmentBuildpathContainerDocumentationCommandHandlerUnableToDisplay, (Throwable)e);
        }
        catch (PartInitException e) {
            throw new ExecutionException(Messages.LuaExecutionEnvironmentBuildpathContainerDocumentationCommandHandlerUnableToDisplay, (Throwable)e);
        }
        catch (CoreException e) {
            throw new ExecutionException(Messages.LuaExecutionEnvironmentBuildpathContainerDocumentationCommandHandlerUnableToDisplay, (Throwable)e);
        }
        throw new ExecutionException(Messages.LuaExecutionEnvironmentBuildpathContainerDocumentationCommandHandlerUnableToFindExecutionEnvironment);
    }

    private IPath getExecutionEnvironmentContainer(ExecutionEvent event) {
        Object firstElement;
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)currentSelection).getFirstElement()) instanceof BuildPathContainer) {
            BuildPathContainer bpc = (BuildPathContainer)firstElement;
            IBuildpathEntry entry = bpc.getBuildpathEntry();
            return entry.getPath();
        }
        return null;
    }
}

