/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.linuxtools.internal.rpmstubby.AbstractGenerator;
import org.eclipse.linuxtools.internal.rpmstubby.model.PerlModel;

public class StubbyMakefilePLGenerator
extends AbstractGenerator {
    private PerlModel model;

    public StubbyMakefilePLGenerator(IFile makefile) {
        this.parse(makefile);
        this.specfileName = String.valueOf(this.model.getPackageName().toLowerCase()) + ".spec";
        this.projectName = makefile.getProject().getName();
    }

    private void parse(IFile makefile) {
        this.model = new PerlModel(makefile);
    }

    @Override
    public String generateSpecfile() {
        StringBuilder buffer = new StringBuilder();
        String packageName = this.model.getPackageName();
        buffer.append("Name:           " + packageName.toLowerCase() + "\n");
        buffer.append("Version:        " + this.model.getVersion() + "\n");
        buffer.append("Release:        1%{?dist}\n");
        buffer.append("Summary:        " + this.model.getSummary() + "\n\n");
        buffer.append("Group:          Development/Libraries\n");
        buffer.append("License:        GPL+ or Artistic\n");
        buffer.append("URL:            " + this.model.getURL() + "\n");
        buffer.append("Source0:        #FIXME\n\n");
        buffer.append("BuildArch:      noarch\n");
        this.generateRequires(buffer);
        buffer.append("%{?perl_default_filter}\n\n\n");
        buffer.append("%description\n" + this.model.getDescription() + "\n\n\n");
        StubbyMakefilePLGenerator.generatePrepSection(buffer);
        StubbyMakefilePLGenerator.generateBuildSection(buffer);
        StubbyMakefilePLGenerator.generateInstallSection(buffer);
        StubbyMakefilePLGenerator.generateFilesSections(buffer);
        StubbyMakefilePLGenerator.generateChangelog(buffer);
        return buffer.toString();
    }

    private void generateRequires(StringBuilder buffer) {
        buffer.append("BuildRequires:  perl(ExtUtils::MakeMaker)\n");
        List<String> requires = this.model.getInstallRequires();
        if (!requires.isEmpty()) {
            for (String str : requires) {
                buffer.append("BuildRequires:  " + str + "\n");
            }
        }
        buffer.append("Requires:  \t    perl(:MODULE_COMPAT_%(eval \"`%{__perl} -V:version`\"; echo $version))\n\n");
    }

    private static void generatePrepSection(StringBuilder buffer) {
        buffer.append("%prep\n");
        buffer.append("%setup -q #You may need to update this according to your Source0\n\n\n");
    }

    private static void generateBuildSection(StringBuilder buffer) {
        buffer.append("%build\n");
        buffer.append("%{__perl} Makefile.PL INSTALLDIRS=vendor\n\n\n");
    }

    private static void generateInstallSection(StringBuilder buffer) {
        buffer.append("%install\n");
        buffer.append("make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT\n\n\n");
    }

    private static void generateFilesSections(StringBuilder buffer) {
        buffer.append("%files\n");
        buffer.append("%{perl_vendorlib}/*\n\n\n");
    }
}

